/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumSetStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionStructureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementStructureImpl
implements JSImplicitElementStructure {
    protected static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    protected static final EnumSetStructureElement<JSImplicitElement.Property> PROPERTIES_FLAG = new EnumSetStructureElement<JSImplicitElement.Property>(JSImplicitElement.Property.class);
    protected static final EnumStructureElement<JSImplicitElement.Type> TYPE_FLAG = new EnumStructureElement<JSImplicitElement.Type>(JSImplicitElement.Type.class);
    protected static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    protected static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    protected static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_TYPE_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_USER_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(NAMESPACE_EXPLICITLY_DECLARED_FLAG, PROPERTIES_FLAG, TYPE_FLAG, JS_CONTEXT_FLAG, ACCESS_TYPE_FLAG, DEPRECATED_FLAG, HAS_TYPE_STRING_FLAG, HAS_USER_STRING_FLAG, IS_CLASS_FLAG, IS_INTERFACE_FLAG);
    protected final int myFlags;
    @NotNull
    protected final String myName;
    @Nullable
    private final JSQualifiedName myNamespace;
    @Nullable
    protected final String myTypeString;
    @Nullable
    private final String myUserString;

    public JSImplicitElementStructureImpl(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "<init>"));
        }
        this.myName = builder.myName;
        this.myNamespace = builder.myNamespace;
        this.myTypeString = builder.myTypeString;
        this.myUserString = builder.myUserString;
        int flags = builder.myFlags;
        JSImplicitElement.Type type = JSImplicitElementStructureImpl.readFlag(TYPE_FLAG, flags);
        if (type.providesNamespace()) {
            flags = JSImplicitElementStructureImpl.writeFlag(flags, type == JSImplicitElement.Type.Interface ? IS_INTERFACE_FLAG : IS_CLASS_FLAG, true);
        }
        this.myFlags = flags;
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSImplicitFunctionStructureImpl);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public String getQualifiedName() {
        String prefix = this.myNamespace != null ? this.myNamespace.getQualifiedName() + "." : "";
        String string = prefix + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getQualifiedName"));
        }
        return string;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    @Nullable
    public String getUserString() {
        return this.myUserString;
    }

    protected final <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return JSImplicitElementStructureImpl.readFlag(structureElement, this.myFlags);
    }

    protected static <T> T readFlag(FlagsStructureElement<T> structureElement, int flags) {
        return IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, structureElement, flags);
    }

    @Contract(pure=true)
    protected static <T> int writeFlag(int currentFlags, FlagsStructureElement<T> structureElement, T value) {
        return IntFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, structureElement, value, currentFlags);
    }

    public void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "serialize"));
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(this.myName, this.myNamespace);
        JSQualifiedNameImpl.serialize((JSQualifiedName)qName, dataStream);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        if (this.myTypeString != null) {
            assert (this.readFlag(HAS_TYPE_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
        }
        if (this.myUserString != null) {
            assert (this.readFlag(HAS_USER_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myUserString);
        }
    }

    @NotNull
    public static JSImplicitElementStructureImpl deserialize(DataInput dataStream) throws IOException {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.deserialize(dataStream);
        assert (name != null);
        int flags = DataInputOutputUtil.readINT((DataInput)dataStream);
        boolean hasType = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_STRING_FLAG, flags);
        String typeString = hasType ? IOUtil.readUTF((DataInput)dataStream) : null;
        boolean hasUserString = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_USER_STRING_FLAG, flags);
        String userString = hasUserString ? IOUtil.readUTF((DataInput)dataStream) : null;
        JSImplicitElement.Type type = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TYPE_FLAG, flags);
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, null);
        builder.setTypeString(typeString).setNamespace(name.getParent()).setFlags(flags).setPossiblyUnregisteredUserString(userString);
        if (type == JSImplicitElement.Type.Function) {
            JSImplicitFunctionStructureImpl.deserializeParameters(dataStream, builder);
        }
        JSImplicitElementStructureImpl jSImplicitElementStructureImpl = builder.toImplicitElementStructure();
        if (jSImplicitElementStructureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "deserialize"));
        }
        return jSImplicitElementStructureImpl;
    }

    @NotNull
    public static JSImplicitElement fromQualifiedName(String qName, @Nullable PsiElement provider) {
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(qualifiedName.getName(), qualifiedName.getParent(), provider);
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "fromQualifiedName"));
        }
        return jSImplicitElementImpl;
    }

    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.readFlag(TYPE_FLAG);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean hasMinorImportance() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.MinorImportance);
    }

    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString;
    }

    public boolean isConst() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.Constant);
    }

    @NotNull
    public JSImplicitElementImpl.Builder toBuilder() {
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(this.myName, null);
        this.fillBuilder(builder);
        JSImplicitElementImpl.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "toBuilder"));
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "fillBuilder"));
        }
        builder.setName(this.myName).setNamespace(this.myNamespace).setFlags(this.myFlags).setTypeString(this.myTypeString).setUserString(this.myUserString);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.readFlag(IS_INTERFACE_FLAG) != false ? JSElementBase.ClassOrInterface.INTERFACE : (this.readFlag(IS_CLASS_FLAG) != false ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof JSImplicitElementStructureImpl)) {
            return false;
        }
        JSImplicitElementStructureImpl other = (JSImplicitElementStructureImpl)obj;
        return this.myFlags == other.myFlags && this.myName.equals(other.myName) && ComparatorUtil.equalsNullable((Object)this.myNamespace, (Object)other.myNamespace) && ComparatorUtil.equalsNullable((Object)this.myTypeString, (Object)other.myTypeString);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @NotNull
    public JSImplicitElementImpl toImplicitElement(@Nullable PsiElement provider) {
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(this, provider);
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl", "toImplicitElement"));
        }
        return jSImplicitElementImpl;
    }
}

