/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSImplicitParameterImpl
implements JSParameterItem {
    @NotNull
    private final JSImplicitParameterStructure myStructure;
    @Nullable
    private final PsiElement myProvider;

    public JSImplicitParameterImpl(@NotNull JSImplicitParameterStructure structure, @Nullable PsiElement provider) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterImpl", "<init>"));
        }
        this.myStructure = structure;
        this.myProvider = provider;
    }

    @Nullable
    public JSType getType() {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myProvider, this.myStructure.isTypeExplicitlyDeclared());
        return JSTypeUtils.createType(this.myStructure.getTypeString(), typeSource);
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        return this.getType();
    }

    public boolean isOptional() {
        return this.myStructure.isOptional();
    }

    public boolean isRest() {
        return this.myStructure.isRest();
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        boolean isExplicitlyDeclared = this.myStructure.isTypeExplicitlyDeclared();
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getType(), this.isOptional(), this.isRest(), isExplicitlyDeclared);
        if (jSParameterTypeDecoratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterImpl", "getTypeDecorator"));
        }
        return jSParameterTypeDecoratorImpl;
    }

    @Nullable
    public String getName() {
        return this.myStructure.getName();
    }
}

