/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSArrayType {
    @NotNull
    public JSGenericTypeImpl asGenericType();

    public static class GenericArrayBuilder {
        @NotNull
        public static JSGenericTypeImpl getGenericType(@NotNull JSType sourceType, @Nullable JSType generic) {
            if (sourceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/intellij/lang/javascript/psi/types/JSArrayType$GenericArrayBuilder", "getGenericType"));
            }
            JSTypeSource source = sourceType.getSource();
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedType.createType("Array", source, JSContext.INSTANCE), generic);
            if (jSGenericTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayType$GenericArrayBuilder", "getGenericType"));
            }
            return jSGenericTypeImpl;
        }
    }
}

