/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSEvaluableTypeBase
extends JSSimpleTypeBaseImpl
implements JSEvaluableType {
    protected JSEvaluableTypeBase(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "<init>"));
        }
        super(source);
    }

    @NotNull
    protected JSType evaluateTypeInRange(@Nullable Set<PsiElement> expandedElements, @Nullable Segment range) {
        PsiElement element;
        JSTypeSource source = this.getSource();
        PsiElement sourceElement = source.getSourceElement();
        JSAnyType defaultType = JSAnyType.get((PsiElement)this.getScope(), false);
        if (sourceElement == null || !sourceElement.isValid()) {
            JSAnyType jSAnyType = defaultType;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "evaluateTypeInRange"));
            }
            return jSAnyType;
        }
        PsiFile scope = source.getScope();
        if (scope == null) {
            JSAnyType jSAnyType = defaultType;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "evaluateTypeInRange"));
            }
            return jSAnyType;
        }
        PsiElement psiElement = element = range != null ? scope.findElementAt(range.getStartOffset()) : null;
        while (element != null && !(element instanceof PsiFile) && element.getTextRange().getStartOffset() == range.getStartOffset() && element.getTextRange().getEndOffset() <= range.getEndOffset()) {
            JSType exprType;
            if (element.getTextRange().getEndOffset() == range.getEndOffset() && (exprType = this.processElement(expandedElements, defaultType, element)) != null) {
                JSType jSType = exprType;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "evaluateTypeInRange"));
                }
                return jSType;
            }
            element = element.getParent();
        }
        JSAnyType jSAnyType = defaultType;
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "evaluateTypeInRange"));
        }
        return jSAnyType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED || format == JSType.TypeTextFormat.SIMPLE) {
            Segment range = this.getSegment();
            String string = range == null ? JSAnyType.get((PsiElement)this.getScope(), false).getTypeText(JSType.TypeTextFormat.SERIALIZED) : this.getPrefix() + "(" + range.getStartOffset() + "," + range.getEndOffset() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "getTypeText"));
            }
            return string;
        }
        JSType evaluatedType = this.evaluateType();
        String string = evaluatedType.getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "isDirectlyAssignableTypeImpl"));
        }
        JSType type = this.evaluateType();
        return type.isDirectlyAssignableType(elementType, processingContext);
    }

    protected abstract JSType processElement(@Nullable Set<PsiElement> var1, @NotNull JSType var2, @NotNull PsiElement var3);

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "isEquivalentToImpl"));
        }
        if (this.getClass() != type.getClass()) {
            return false;
        }
        if (!allowResolve) {
            JSEvaluableTypeBase otherType = (JSEvaluableTypeBase)type;
            Segment segment = this.getSegment();
            Segment otherTypeSegment = otherType.getSegment();
            if (segment != null && segment.equals(otherTypeSegment)) {
                return this.getSource().getSourceElement() == otherType.getSource().getSourceElement();
            }
            return false;
        }
        JSType thisType = this.evaluateType();
        type = ((JSEvaluableTypeBase)type).evaluateType();
        return thisType.isEquivalentTo(type, processingContext);
    }

    public abstract JSType evaluateType();

    protected abstract String getPrefix();

    @Nullable
    public abstract Segment getSegment();

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.evaluateType();
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase", "substitute"));
        }
        return jSType;
    }
}

