/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIndexedAccessJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myOwner;
    @NotNull
    private final JSType myParameterType;

    public TypeScriptIndexedAccessJSTypeImpl(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "<init>"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "<init>"));
        }
        super(source);
        this.myOwner = owner;
        this.myParameterType = parameterType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder result = new StringBuilder();
        if (isSerialized) {
            result.append("#indt");
            result.append("(");
        }
        result.append(this.getOwner().getTypeText(format));
        result.append(isSerialized ? "," : "[");
        result.append(this.getParameterType().getTypeText(format));
        result.append(isSerialized ? "" : "]");
        if (isSerialized) {
            result.append(")");
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "copyTypeHierarchy"));
        }
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(JSTypeUtils.transformTypeHierarchySafe(this.getOwner(), childTransform), JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform), this.getSource());
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "copyTypeHierarchy"));
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        JSType substitute = this.substitute();
        if (substitute != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "copyWithNewSource"));
        }
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(this.getOwner(), this.getParameterType(), source);
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "copyWithNewSource"));
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "isEquivalentToImpl"));
        }
        if (type instanceof TypeScriptIndexedAccessJSTypeImpl) {
            TypeScriptIndexedAccessJSTypeImpl indexedAccessJSType = (TypeScriptIndexedAccessJSTypeImpl)type;
            return indexedAccessJSType.getOwner().isEquivalentTo(this.getOwner(), context, allowResolve) && indexedAccessJSType.getParameterType().isEquivalentTo(this.getParameterType(), context, allowResolve);
        }
        return false;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType ownerType = JSTypeUtils.getValuableType(this.getOwner());
        JSRecordType recordType = ownerType.asRecordType();
        List result = ContainerUtil.newSmartList();
        Set strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(this.getParameterType()).stream().map(el -> el.getLiteral()).collect(Collectors.toSet());
        if (strings.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isExplicitlyDeclared());
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            JSRecordType.PropertySignature propertySignature;
            String name;
            if (!(member instanceof JSRecordType.PropertySignature) || !strings.contains(name = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
            result.add(propertySignature.getType());
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = result.size() == 1 ? (JSType)result.get(0) : new JSCompositeTypeImpl(this.getSource(), result);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "substitute"));
        }
        return jSCompositeTypeImpl;
    }

    public static Collection<JSStringLiteralTypeImpl> getParameterStrings(@NotNull JSType parameterType) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "getParameterStrings"));
        }
        JSType type = JSTypeUtils.getValuableType(parameterType);
        if (type instanceof JSTypeImpl) {
            type = ((JSTypeImpl)type).getTypedef(null, null);
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return ContainerUtil.createMaybeSingletonList((Object)((Object)((JSStringLiteralTypeImpl)type)));
        }
        if (type instanceof JSCompositeTypeImpl) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            for (JSType jsType : ((JSCompositeTypeImpl)type).getTypes()) {
                if (!(jsType instanceof JSStringLiteralTypeImpl)) continue;
                result.add((JSStringLiteralTypeImpl)jsType);
            }
            return result;
        }
        JSType substitute = parameterType.substitute();
        if (substitute != parameterType) {
            return TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(substitute);
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    public JSType getOwner() {
        JSType jSType = this.myOwner;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "getOwner"));
        }
        return jSType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl", "getParameterType"));
        }
        return jSType;
    }
}

