/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private final boolean myReadonly;
    private final boolean myOptional;
    @Nullable
    private final String myParameterName;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;

    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, @Nullable String parameterName, @NotNull JSType parameterType, @NotNull JSType resultType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "<init>"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "<init>"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "<init>"));
        }
        super(source);
        this.myReadonly = isReadonly;
        this.myOptional = isOptional;
        this.myParameterName = parameterName;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder builder = new StringBuilder();
        if (isSerialized) {
            builder.append("#mapped");
        }
        builder.append("{");
        if (this.isReadonly()) {
            builder.append(isSerialized ? "r" : "readonly ");
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name == null ? "MapParameter" : name);
        builder.append(isSerialized ? "+" : " in ");
        builder.append(this.getParameterType().getTypeText(format));
        builder.append("]");
        if (this.isOptional()) {
            builder.append("?");
        }
        builder.append(":");
        builder.append(this.getResultType().getTypeText(format));
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected TypeScriptMappedJSTypeImpl copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "copyTypeHierarchy"));
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(this.getSource(), this.isReadonly(), this.isOptional(), this.myParameterName, JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform), JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform));
        if (typeScriptMappedJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "copyTypeHierarchy"));
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "copyWithNewSource"));
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myParameterName, this.myParameterType, this.myResultType);
        if (typeScriptMappedJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "copyWithNewSource"));
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        JSType substitute = this.substitute();
        if (substitute != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null && element.isValid()) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
            JSType jSType = (JSType)manager.getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.substituteImpl(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSType jSType = this.substituteImpl();
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "substitute"));
        }
        return jSType;
    }

    @NotNull
    private JSType substituteImpl() {
        JSType type = JSTypeUtils.getValuableType(this.getParameterType());
        Collection<JSStringLiteralTypeImpl> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        String name = this.getParameterName();
        if (strings.isEmpty() || name == null) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isExplicitlyDeclared());
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "substituteImpl"));
            }
            return jSAnyType;
        }
        JSType resultType = JSTypeUtils.getValuableType(this.getResultType());
        boolean optional = this.isOptional();
        List result = ContainerUtil.newSmartList();
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(name, ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)resultType;
            JSRecordType ownerRecordType = accessJSType.getOwner().asRecordType();
            Set propertyNames = strings.stream().map(el -> el.getLiteral()).collect(Collectors.toSet());
            for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                String memberName;
                if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                boolean overrideOptional = optional == propertySignature.isOptional();
                result.add(overrideOptional ? new JSRecordTypeImpl.PropertySignatureImpl(memberName, propertySignature.getType(), optional, propertySignature.getSource()) : propertySignature);
            }
        } else {
            for (JSStringLiteralTypeImpl string : strings) {
                JSType propertyType = JSTypeUtils.transformTypeHierarchySafe(resultType, (Function<JSType, JSType>)((Function)el -> {
                    if (TypeScriptMappedJSTypeImpl.isParameter(name, el)) {
                        return string;
                    }
                    return el;
                }));
                if (propertyType instanceof TypeScriptIndexedAccessJSTypeImpl) {
                    propertyType = propertyType.substitute();
                }
                result.add(new JSRecordTypeImpl.PropertySignatureImpl(string.getLiteral(), propertyType, optional));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), result);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "substituteImpl"));
        }
        return jSRecordTypeImpl;
    }

    private static boolean isParameter(@NotNull String name, @NotNull JSType el) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "isParameter"));
        }
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "isParameter"));
        }
        return el instanceof JSTypeImpl && name.equals(el.getTypeText(JSType.TypeTextFormat.SIMPLE));
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "isEquivalentToImpl"));
        }
        if (type instanceof TypeScriptMappedJSTypeImpl) {
            TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
            return this.isReadonly() == mappedType.isReadonly() && this.isOptional() == mappedType.isOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve);
        }
        return false;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "getParameterType"));
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl", "getResultType"));
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }
}

