/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPrimitiveArrayType
extends JSSpecialNamedTypeImpl
implements JSArrayType {
    public JSPrimitiveArrayType(JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if ("Array" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "getTypeText"));
        }
        return "Array";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType type;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeImpl"));
        }
        if (elementType instanceof JSNullType || elementType instanceof JSArrayTypeImpl) {
            return true;
        }
        if (elementType instanceof JSGenericTypeImpl && ((type = ((JSGenericTypeImpl)elementType).getType()) instanceof JSPrimitiveArrayType || type instanceof JSArrayTypeImpl)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType type;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (assignableResult.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult2;
        }
        if (elementType instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)elementType).getType()) instanceof JSNamedType) {
            JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().areNamedTypesAssignable(this, (JSNamedType)type, processingContext));
            if (assignableResult3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult3;
        }
        if (elementType instanceof JSTypeImpl) {
            if ("Arguments".equals(elementType.getResolvedTypeText())) {
                JSTypeCastUtil.AssignableResult assignableResult4 = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                if (assignableResult4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult4;
            }
            JSTypeCastUtil.AssignableResult assignableResult5 = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().areNamedTypesAssignable(this, (JSNamedType)elementType, processingContext));
            if (assignableResult5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult5;
        }
        JSTypeCastUtil.AssignableResult assignableResult6 = assignableResult;
        if (assignableResult6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult6;
    }

    @Override
    @NotNull
    public JSGenericTypeImpl asGenericType() {
        JSGenericTypeImpl jSGenericTypeImpl = JSArrayType.GenericArrayBuilder.getGenericType(this, JSAnyType.get((PsiElement)this.getScope(), false));
        if (jSGenericTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "asGenericType"));
        }
        return jSGenericTypeImpl;
    }
}

