/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSPrimitiveType
extends JSSpecialNamedTypeImpl {
    private final boolean primitive;

    public JSPrimitiveType(boolean primitive, @Nullable JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
        this.primitive = primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType jsType, ProcessingContext processingContext, boolean allowResolve) {
        if (jsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsType", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveType", "isEquivalentToImpl"));
        }
        return jsType.getClass() == ((Object)((Object)this)).getClass() && (((JSPrimitiveType)jsType).isPrimitive() == this.isPrimitive() || this.isTypeScript());
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveType", "isDirectlyAssignableTypeImpl"));
        }
        if (!this.isPrimitive() && elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }
}

