/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;

public class AnalysisUtils {
    public static boolean isLHSExpression(JSExpression expr) {
        if (expr instanceof JSDefinitionExpression) {
            expr = ((JSDefinitionExpression)expr).getExpression();
        }
        if (expr instanceof JSReferenceExpression) {
            return true;
        }
        if (expr instanceof JSParenthesizedExpression) {
            return AnalysisUtils.isLHSExpression(((JSParenthesizedExpression)expr).getInnerExpression());
        }
        if (expr instanceof JSIndexedPropertyAccessExpression) {
            return true;
        }
        if (expr instanceof JSDestructuringContainer) {
            return true;
        }
        if (expr instanceof JSArrayLiteralExpression || expr instanceof JSObjectLiteralExpression) {
            return true;
        }
        if (expr != null && JSInheritedLanguagesHelper.isLHSExpression((PsiElement)expr)) {
            return true;
        }
        return expr instanceof JSPrefixExpression && ((JSPrefixExpression)expr).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
    }
}

