/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSNamesValidator
implements NamesValidator {
    protected final Lexer myLexer;
    private final DialectOptionHolder myDialect;

    JSNamesValidator(DialectOptionHolder optionHolder) {
        this.myLexer = this.createLexer(optionHolder);
        this.myDialect = optionHolder;
    }

    protected Lexer createLexer(DialectOptionHolder optionHolder) {
        return new JSFlexAdapter(optionHolder);
    }

    public synchronized boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "isKeyword"));
        }
        this.myLexer.start((CharSequence)name);
        return JSNamesValidator.getKeywords(this.myDialect).contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "isIdentifier"));
        }
        this.myLexer.start((CharSequence)name);
        return JSNamesValidator.getIdentifiers(this.myDialect).contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    @NotNull
    public static TokenSet getKeywords(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_KEYWORDS;
                if (tokenSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getKeywords"));
                }
                return tokenSet;
            }
            if (dialect.isECMA6) {
                TokenSet tokenSet = JSKeywordSets.ES6_RESERVED_WORDS;
                if (tokenSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getKeywords"));
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_AND_STRICT_KEYWORDS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getKeywords"));
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet getIdentifiers(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getIdentifiers"));
                }
                return tokenSet;
            }
            if (dialect.isTypeScript) {
                TokenSet tokenSet = JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET;
                if (tokenSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getIdentifiers"));
                }
                return tokenSet;
            }
            if (dialect.isJavaScript()) {
                TokenSet tokenSet = JSKeywordSets.JS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getIdentifiers"));
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.IDENTIFIER_TOKENS_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSNamesValidator", "getIdentifiers"));
        }
        return tokenSet;
    }
}

