/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSRefactoringDescriptionLocation;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import org.jetbrains.annotations.NotNull;

public class JSRefactoringElementDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSRefactoringElementDescriptionProvider", "getElementDescription"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/refactoring/JSRefactoringElementDescriptionProvider", "getElementDescription"));
        }
        if (location instanceof RefactoringDescriptionLocation) {
            JSClass parentClassOverride = location instanceof JSRefactoringDescriptionLocation ? ((JSRefactoringDescriptionLocation)location).getOverrideParentClass() : null;
            boolean includeParent = ((RefactoringDescriptionLocation)location).includeParent();
            if (element instanceof JSVariable) {
                return JSFormatUtil.getVariableLongDescription((JSVariable)element, includeParent, true, parentClassOverride);
            }
            if (element instanceof JSFunction) {
                return JSFormatUtil.getFunctionLongDescription((JSFunction)element, includeParent, true, parentClassOverride);
            }
            if (element instanceof JSClass) {
                String key = JSResolveUtil.isFileLocalSymbol(element) ? (((JSClass)element).isInterface() ? "inner.interface.description" : "inner.class.description") : (((JSClass)element).isInterface() ? "interface.description" : "class.description");
                return JSBundle.message((String)key, (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)JSFormatUtil.formatClass((JSClass)element, 1))});
            }
        }
        return null;
    }
}

