/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaScriptSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    private static final TokenSet parameterDelimiterSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COMMA});

    public boolean handlesElement(PsiElement element) {
        return element instanceof JSParameter;
    }

    public NonCodeUsageSearchInfo findUsages(final @NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, final @NotNull List<UsageInfo> usages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "findUsages"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "findUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "findUsages"));
        }
        if (element instanceof JSParameter) {
            PsiElement fun = element.getParent().getParent();
            if (!(fun instanceof JSFunction)) {
                return null;
            }
            int currentParameterIndex = 0;
            int parameterIndex = -1;
            for (JSParameter p : ((JSFunction)fun).getParameterVariables()) {
                if (p == element) {
                    parameterIndex = currentParameterIndex;
                    break;
                }
                ++currentParameterIndex;
            }
            String paramName = ((JSParameter)element).getName();
            PsiComment comment = JSDocumentationUtils.findFunctionComment((JSFunction)fun);
            if (comment instanceof JSDocComment) {
                JSDocTag[] tags;
                for (JSDocTag tag : tags = ((JSDocComment)comment).getTags()) {
                    JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                    if ((docTag == null || docTag.type != JSDocumentationProcessor.MetaDocType.PARAMETER || docTag.matchName == null || !docTag.matchName.equals(paramName)) && !docTag.matchName.startsWith(paramName + ".")) continue;
                    usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)tag, element, true));
                }
            }
            if (parameterIndex == -1) {
                return null;
            }
            final int finalParameterIndex = parameterIndex;
            ReferencesSearch.search((PsiElement)fun).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement parent;
                    if (psiReference instanceof JSReferenceExpression && (parent = ((JSReferenceExpression)psiReference).getParent()) instanceof JSCallExpression) {
                        JSExpression[] args;
                        final JSArgumentList argumentList = ((JSCallExpression)parent).getArgumentList();
                        JSExpression[] jSExpressionArray = args = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
                        if (args.length > finalParameterIndex) {
                            usages.add(new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)args[finalParameterIndex], element, true){

                                public void deleteElement() throws IncorrectOperationException {
                                    PsiElement comma = null;
                                    if (this.isSafeDelete()) {
                                        ASTNode commaNode = null;
                                        ASTNode argumentListNode = argumentList.getNode();
                                        if (finalParameterIndex < args.length - 1) {
                                            commaNode = argumentListNode.findChildByType(parameterDelimiterSet, args[finalParameterIndex].getNode());
                                        } else {
                                            ASTNode[] astNodes = argumentListNode.getChildren(parameterDelimiterSet);
                                            if (astNodes.length > 0) {
                                                commaNode = astNodes[astNodes.length - 1];
                                            }
                                        }
                                        if (commaNode != null) {
                                            comma = commaNode.getPsi();
                                        }
                                    }
                                    super.deleteElement();
                                    if (comma != null && comma.isValid()) {
                                        comma.delete();
                                    }
                                }
                            });
                        }
                    }
                    return true;
                }
            });
            return new NonCodeUsageSearchInfo(Conditions.alwaysFalse(), element);
        }
        return null;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "getElementsToSearch"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "getElementsToSearch"));
        }
        return Collections.singletonList(element);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        return null;
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "findConflicts"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor", "findConflicts"));
        }
        return null;
    }

    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

