/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperBaseDialog;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperProcessor;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JSExtractInterfaceDialog
extends JSExtractSuperBaseDialog {
    public JSExtractInterfaceDialog(Project project, JSClass sourceClass, JSElement selectedElement, String refactoringName) {
        super(project, sourceClass, JSExtractInterfaceDialog.collectMembers(sourceClass, selectedElement, true), refactoringName);
        this.init();
    }

    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return RefactoringBundle.message((String)"no.interface.name.specified");
    }

    protected String getTopLabelText() {
        return RefactoringBundle.message((String)"extract.interface.from");
    }

    protected BaseRefactoringProcessor createProcessor() {
        return new JSExtractSuperProcessor((JSClass)this.mySourceClass, (JSMemberInfo[])ArrayUtil.toObjectArray(this.getSelectedMemberInfos(), JSMemberInfo.class), this.getExtractedSuperName(), this.getTargetPackageName(), this.getDocCommentPolicy(), this.getMode(), false, this.getTargetDirectory());
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JSMemberSelectionPanel memberSelectionPanel = new JSMemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.interface"), this.myMemberInfos, null);
        MyMemberInfoModel model = new MyMemberInfoModel((JSClass)this.mySourceClass);
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)model);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)model);
        model.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        panel.add((Component)memberSelectionPanel, "Center");
        if (!((JSClass)this.mySourceClass).isInterface()) {
            panel.add((Component)this.myDocCommentPanel, "East");
        }
        return panel;
    }

    protected String getHelpId() {
        return "refactor.extractInterface";
    }

    protected String getClassNameLabelText() {
        JSExtractSuperProcessor.Mode mode = this.getMode();
        return mode == JSExtractSuperProcessor.Mode.ExtractSuper || mode == JSExtractSuperProcessor.Mode.ExtractSuperTurnRefs ? RefactoringBundle.message((String)"interface.name.prompt") : RefactoringBundle.message((String)(((JSClass)this.mySourceClass).isInterface() ? "rename.original.interface.to" : "rename.implementation.class.to"));
    }

    protected String getPackageNameLabelText() {
        JSExtractSuperProcessor.Mode mode = this.getMode();
        return mode == JSExtractSuperProcessor.Mode.ExtractSuper || mode == JSExtractSuperProcessor.Mode.ExtractSuperTurnRefs ? RefactoringBundle.message((String)"package.for.new.interface") : RefactoringBundle.message((String)(((JSClass)this.mySourceClass).isInterface() ? "package.for.original.interface" : "package.for.original.class"));
    }

    protected String getEntityName() {
        return RefactoringBundle.message((String)"extractSuperInterface.interface");
    }

    public static class MyContainmentVerifier
    implements JSInterfaceContainmentVerifier {
        private final List<JSMemberInfo> myMemberInfos;

        public MyContainmentVerifier(List<JSMemberInfo> memberInfos) {
            this.myMemberInfos = memberInfos;
        }

        @Override
        public boolean checkedInterfacesContain(JSFunction psiMethod) {
            return JSPullUpHelper.checkedInterfacesContain(this.myMemberInfos, psiMethod);
        }
    }

    private class MyMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        public MyMemberInfoModel(JSClass aClass) {
            super(aClass, null, false, new MyContainmentVerifier(JSExtractInterfaceDialog.this.myMemberInfos));
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractInterfaceDialog$MyMemberInfoModel", "checkForProblems"));
            }
            return 0;
        }
    }
}

