/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceConstant;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantInfoProvider
extends BasicIntroducedEntityInfoProvider {
    public IntroduceConstantInfoProvider(JSExpression mainOccurrence, JSExpression[] occurrences, PsiElement scope) {
        super(mainOccurrence, occurrences, scope);
    }

    @Override
    public String[] suggestCandidateNames() {
        if (this.myMainOccurrence instanceof JSLiteralExpression) {
            LinkedHashSet names = new LinkedHashSet();
            String text = StringUtil.stripQuotesAroundValue((String)this.myMainOccurrence.getText());
            names.addAll(NameUtil.getSuggestionsByName((String)text, (String)"", (String)"", (boolean)true, (boolean)true, (boolean)false));
            return ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray(names), (String[])super.suggestCandidateNames());
        }
        return super.suggestCandidateNames();
    }

    @Override
    public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurences) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduceConstant/IntroduceConstantInfoProvider", "checkConflicts"));
        }
        return true;
    }

    @Override
    protected boolean processStatics(PsiElement place) {
        return true;
    }
}

