/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;

public abstract class JSClassMemberReferencesVisitor
extends JSRecursiveElementVisitor {
    private final JSClass myClass;

    public JSClassMemberReferencesVisitor(JSClass aClass) {
        this.myClass = aClass;
    }

    protected abstract void visitMemberReference(JSAttributeListOwner var1, JSReferenceExpression var2);

    public void visitJSReferenceExpression(JSReferenceExpression expression) {
        PsiElement resovled;
        JSExpression qualifier = expression.getQualifier();
        if (qualifier != null && !(qualifier instanceof JSThisExpression) && !(qualifier instanceof JSSuperExpression)) {
            qualifier.accept((PsiElementVisitor)this);
            if (!(qualifier instanceof JSReferenceExpression) || !(((JSReferenceExpression)qualifier).resolve() instanceof JSClass)) {
                return;
            }
        }
        if ((resovled = expression.resolve()) instanceof JSAttributeListOwner && JSInheritanceUtil.isMemberOfSubclass(this.myClass, (JSElement)resovled, true)) {
            this.visitMemberReference((JSAttributeListOwner)resovled, expression);
        }
    }
}

