/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPass;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceHighlightingPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final JSLanguageServiceHighlightingStateHolder mySharedCalcHolder;

    protected JSLanguageServiceHighlightingPassFactory(Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        if (highlightingPassRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingPassRegistrar", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory", "<init>"));
        }
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, -1);
        this.mySharedCalcHolder = new JSLanguageServiceHighlightingStateHolder();
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory", "createHighlightingPass"));
        }
        if (!this.isAcceptablePsiFile(file)) {
            return null;
        }
        JSLanguageService service = this.getService();
        if (service == null || !this.isAcceptableService(file, service)) {
            return null;
        }
        return new JSLanguageServiceHighlightingPass(this.myProject, service, file, this.mySharedCalcHolder, editor);
    }

    public boolean isAcceptableService(@NotNull PsiFile file, @Nullable JSLanguageService service) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory", "isAcceptableService"));
        }
        return service != null && service.isAcceptable(file.getVirtualFile());
    }

    @Nullable
    protected abstract JSLanguageService getService();

    protected boolean isAcceptablePsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory", "isAcceptablePsiFile"));
        }
        return file instanceof JSFile;
    }

    public void disposeComponent() {
        super.disposeComponent();
        this.mySharedCalcHolder.reset();
    }
}

