/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceActionPanelBuilder {
    public static JPanel createToolPanel(@NotNull String helpId, final @Nullable Runnable closeToolbar, final @NotNull Runnable cleanPanelAction, @Nullable AnAction[] rightPanelActions, @Nullable AnAction[] leftPanelActions) {
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceActionPanelBuilder", "createToolPanel"));
        }
        if (cleanPanelAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanPanelAction", "com/intellij/lang/javascript/service/ui/JSLanguageServiceActionPanelBuilder", "createToolPanel"));
        }
        CloseTabToolbarAction closeMessageViewAction = null;
        if (closeToolbar != null) {
            closeMessageViewAction = new CloseTabToolbarAction(){

                public void actionPerformed(AnActionEvent e) {
                    closeToolbar.run();
                }
            };
        }
        DefaultActionGroup leftUpdateableActionGroup = new DefaultActionGroup();
        DefaultActionGroup rightUpdateableActionGroup = new DefaultActionGroup();
        if (rightPanelActions != null) {
            for (AnAction action : rightPanelActions) {
                rightUpdateableActionGroup.add(action);
            }
        }
        rightUpdateableActionGroup.add((AnAction)new DumbAwareAction("Clear All", null, AllIcons.Actions.GC){

            public void actionPerformed(AnActionEvent e) {
                cleanPanelAction.run();
            }
        });
        if (leftPanelActions != null) {
            for (AnAction action : leftPanelActions) {
                leftUpdateableActionGroup.add(action);
            }
        }
        leftUpdateableActionGroup.add((AnAction)new ContextHelpAction(helpId));
        if (closeMessageViewAction != null) {
            leftUpdateableActionGroup.add((AnAction)closeMessageViewAction);
        }
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar leftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)leftUpdateableActionGroup, false);
        ActionToolbar rightToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)rightUpdateableActionGroup, false);
        toolbarPanel.add((Component)leftToolbar.getComponent(), "West");
        toolbarPanel.add((Component)rightToolbar.getComponent(), "Center");
        return toolbarPanel;
    }
}

