/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public class JavaScriptParameterListSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        IElementType type;
        ASTNode astNode = e.getNode();
        return astNode != null && ((type = astNode.getElementType()) == JSElementTypes.ARGUMENT_LIST || JSElementTypes.PARAMETER_LISTS.contains(type));
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ASTNode lpar = e.getNode().findChildByType(JSTokenTypes.LPAR);
        ASTNode rpar = e.getNode().findChildByType(JSTokenTypes.RPAR);
        if (lpar == null || rpar == null) {
            return Collections.emptyList();
        }
        return new SmartList((Object)new TextRange(lpar.getTextRange().getEndOffset(), rpar.getStartOffset()));
    }
}

