/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.lang.javascript.template.postfix.JSStringBasedPostfixTemplate;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAwaitPostfixTemplate
extends JSStringBasedPostfixTemplate {
    private static final Condition<PsiElement> ASYNC_CONTEXT = element -> {
        JSElement context = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class);
        return context instanceof JSFunction && ES6PsiUtil.isAsyncContext((JSFunction)context);
    };

    public JSAwaitPostfixTemplate() {
        super("await", "await expr", JSPostfixTemplateUtils.selectorWithFeature(JSPostfixTemplateUtils.selectorTopmost(), JSLanguageFeature.ASYNC_AWAIT, ASYNC_CONTEXT));
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSAwaitPostfixTemplate", "getTemplateString"));
        }
        return "await $expr$" + JSPostfixTemplateUtils.endTemplate(element);
    }
}

