/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript._JSInHtmlStripper;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSEmbeddedContentStubImpl;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEmbeddedContentElementType
extends JSStubElementType<JSEmbeddedContentStub, JSEmbeddedContent>
implements EmbeddingElementType,
ICustomParsingType,
ILazyParseableElementTypeBase {
    @Nullable
    private final Language myForcedLanguage;

    public JSEmbeddedContentElementType(@Nullable Language forcedLanguage, @NotNull String externalIdPrefix) {
        if (externalIdPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalIdPrefix", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "<init>"));
        }
        super(externalIdPrefix + "EMBEDDED_CONTENT");
        this.myForcedLanguage = forcedLanguage;
    }

    @NotNull
    public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "parse"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "parse"));
        }
        LazyParseableElement lazyParseableElement = new LazyParseableElement((IElementType)this, text);
        if (lazyParseableElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "parse"));
        }
        return lazyParseableElement;
    }

    protected Lexer createStripperLexer(Language baseLanguage) {
        LayeredLexer lexer = new LayeredLexer((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _JSInHtmlStripper()), JSTokenTypes.XML_JS_TEXT_SET));
        DialectOptionHolder holder = baseLanguage instanceof JSLanguageDialect ? ((JSLanguageDialect)baseLanguage).getOptionHolder() : JSLanguageLevel.DEFAULT.getDialect().getOptionHolder();
        lexer.registerLayer((Lexer)new JSFlexAdapter(holder), new IElementType[]{JSTokenTypes.XML_JS_TEXT});
        return lexer;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSEmbeddedContentImpl(node);
    }

    @Nullable
    public Language getForcedLanguage() {
        return this.myForcedLanguage;
    }

    @NotNull
    public JSEmbeddedContentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "deserialize"));
        }
        JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(dataStream, parentStub, (IStubElementType)this);
        if (jSEmbeddedContentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "deserialize"));
        }
        return jSEmbeddedContentStubImpl;
    }

    @NotNull
    public JSEmbeddedContentStub createStub(@NotNull JSEmbeddedContent psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "createStub"));
        }
        JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(psi, parentStub, (IStubElementType)this);
        if (jSEmbeddedContentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedContentElementType", "createStub"));
        }
        return jSEmbeddedContentStubImpl;
    }

    public ASTNode parseContents(ASTNode chameleon) {
        PsiElement context = chameleon.getPsi();
        Language language = JSEmbeddedContentImpl.getLanguageForParser((IElementType)this, context.getProject());
        Lexer lexer = this.createStripperLexer(language);
        Project project = context.getProject();
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language, chameleon.getChars());
        JavaScriptParser parser = language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).createParser(builder) : new JavaScriptParser(null, builder);
        builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)parser.getDialect());
        parser.parseJS((IElementType)this);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    public String toString() {
        return StringUtil.trimStart((String)super.toString(), (String)"JS:");
    }
}

