/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSEmbeddedContentStubImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEmbeddedExpressionElementType
extends JSStubElementType<JSEmbeddedContentStub, JSEmbeddedContent>
implements EmbeddingElementType,
ICustomParsingType,
ILazyParseableElementTypeBase {
    public JSEmbeddedExpressionElementType() {
        super("XML_JS_SCRIPT");
    }

    public ASTNode parseContents(ASTNode chameleon) {
        PsiElement parentElement = chameleon.getTreeParent().getPsi();
        Project project = parentElement.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        while (parentElement instanceof XmlElement) {
            parentElement = parentElement.getParent();
        }
        Language language = parentElement != null ? parentElement.getLanguage() : null;
        JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
        JSLanguageDialect dialect = language instanceof JSLanguageDialect ? (JSLanguageDialect)language : (configuration != null ? configuration.getLanguageLevel().getDialect() : JSLanguageLevel.DEFAULT.getDialect());
        PsiBuilder builder = factory.createBuilder(project, chameleon, null, (Language)dialect, (CharSequence)chameleon.getText());
        builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)dialect);
        JSEmbeddedExpressionElementType.doParse(builder);
        return builder.getTreeBuilt();
    }

    private static void doParse(PsiBuilder builder) {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)builder.getUserData(JavaScriptParserBase.JS_DIALECT_KEY));
        assert (dialect != null);
        JavaScriptParser<?, ?, ?, ?> parser = dialect.createParser(builder);
        ((ExpressionParser)parser.getExpressionParser()).parseScriptExpression();
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSEmbeddedContentImpl(node);
    }

    @NotNull
    public JSEmbeddedContentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "deserialize"));
        }
        JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(dataStream, parentStub, (IStubElementType)this);
        if (jSEmbeddedContentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "deserialize"));
        }
        return jSEmbeddedContentStubImpl;
    }

    @NotNull
    public JSEmbeddedContentStub createStub(@NotNull JSEmbeddedContent psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "createStub"));
        }
        JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(psi, parentStub, (IStubElementType)this);
        if (jSEmbeddedContentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "createStub"));
        }
        return jSEmbeddedContentStubImpl;
    }

    @NotNull
    public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "parse"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "parse"));
        }
        LazyParseableElement lazyParseableElement = new LazyParseableElement((IElementType)this, text);
        if (lazyParseableElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSEmbeddedExpressionElementType", "parse"));
        }
        return lazyParseableElement;
    }

    public String toString() {
        return super.toString().substring(3);
    }
}

