/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSReturnStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSReturnStatementStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReturnStatementElementType
extends JSStubElementType<JSReturnStatementStub, JSReturnStatement> {
    public JSReturnStatementElementType() {
        super("RETURN_STATEMENT");
    }

    @NotNull
    public JSReturnStatementStub createStub(@NotNull JSReturnStatement psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSReturnStatementElementType", "createStub"));
        }
        JSReturnStatementStubImpl jSReturnStatementStubImpl = new JSReturnStatementStubImpl(psi, parentStub);
        if (jSReturnStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSReturnStatementElementType", "createStub"));
        }
        return jSReturnStatementStubImpl;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSReturnStatementImpl(node);
    }

    @NotNull
    public JSReturnStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSReturnStatementElementType", "deserialize"));
        }
        JSReturnStatementStubImpl jSReturnStatementStubImpl = new JSReturnStatementStubImpl(dataStream, parentStub);
        if (jSReturnStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSReturnStatementElementType", "deserialize"));
        }
        return jSReturnStatementStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode expressionNode = JSReturnStatementImpl.getExpressionNode(node);
        return expressionNode != null && (expressionNode.getElementType() == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(expressionNode.getElementType()));
    }
}

