/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVariableStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JSVariableElementType
extends JSStubElementType<JSVariableStub<JSVariable>, JSVariable> {
    public JSVariableElementType() {
        super("VARIABLE");
    }

    public JSVariableElementType(String debugName) {
        super(debugName);
    }

    @NotNull
    public JSVariableStub<JSVariable> createStub(@NotNull JSVariable psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSVariableElementType", "createStub"));
        }
        JSVariableStubImpl jSVariableStubImpl = new JSVariableStubImpl(psi, parentStub, this);
        if (jSVariableStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSVariableElementType", "createStub"));
        }
        return jSVariableStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        return JSVariableElementType.shouldCreateStubForVariable(node);
    }

    public PsiElement construct(ASTNode node) {
        return new JSVariableImpl(node);
    }

    @NotNull
    public JSVariableStub<JSVariable> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSVariableElementType", "deserialize"));
        }
        JSVariableStubImpl jSVariableStubImpl = new JSVariableStubImpl(dataStream, parentStub, (IStubElementType)this);
        if (jSVariableStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSVariableElementType", "deserialize"));
        }
        return jSVariableStubImpl;
    }

    public boolean shouldIndexSymbol(@NotNull JSVariable psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSVariableElementType", "shouldIndexSymbol"));
        }
        return !psi.isLocal();
    }

    public static boolean shouldCreateStubForVariable(ASTNode node) {
        String name = JSTreeUtil.getName(node);
        for (ASTNode parent = node; parent != null; parent = parent.getTreeParent()) {
            IElementType type = parent.getElementType();
            if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) {
                if (name != null && JSTreeUtil.findReturnedReferences((CompositeElement)parent).contains(name)) {
                    return true;
                }
                ASTNode docComment = node.findChildByType(JSStubElementTypes.DOC_COMMENT);
                if (docComment == null) {
                    docComment = node.getTreeParent().findChildByType(JSStubElementTypes.DOC_COMMENT);
                }
                return docComment != null && docComment.getFirstChildNode() != null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type)) continue;
            return true;
        }
        return !JSVariableBaseImpl.hasBlockScope(node);
    }
}

