/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptVariableImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.impl.TypeScriptVariableStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableElementType
extends JSStubElementType<JSVariableStub<JSVariable>, JSVariable> {
    public TypeScriptVariableElementType() {
        this("TYPESCRIPT_VARIABLE");
    }

    public TypeScriptVariableElementType(String name) {
        super(name);
    }

    @NotNull
    public JSVariableStub<JSVariable> createStub(@NotNull JSVariable psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/TypeScriptVariableElementType", "createStub"));
        }
        TypeScriptVariableStubImpl typeScriptVariableStubImpl = new TypeScriptVariableStubImpl(psi, parentStub, (JSStubElementType<?, JSVariable>)this);
        if (typeScriptVariableStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeScriptVariableElementType", "createStub"));
        }
        return typeScriptVariableStubImpl;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new TypeScriptVariableImpl(node);
    }

    @NotNull
    public JSVariableStub<JSVariable> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/TypeScriptVariableElementType", "deserialize"));
        }
        TypeScriptVariableStubImpl typeScriptVariableStubImpl = new TypeScriptVariableStubImpl(dataStream, parentStub, (JSStubElementType<?, JSVariable>)this);
        if (typeScriptVariableStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeScriptVariableElementType", "deserialize"));
        }
        return typeScriptVariableStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        for (ASTNode parent = node; parent != null; parent = parent.getTreeParent()) {
            IElementType type = parent.getElementType();
            if (!JSElementTypes.FUNCTION_DECLARATIONS.contains(type) && !JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) continue;
            return false;
        }
        return true;
    }

    public boolean shouldIndexSymbol(@NotNull JSVariable psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/TypeScriptVariableElementType", "shouldIndexSymbol"));
        }
        PsiElement grandParent = psi.getParent().getParent();
        return grandParent instanceof TypeScriptClass || grandParent instanceof TypeScriptEnum || grandParent instanceof JSFile || grandParent instanceof TypeScriptModule;
    }
}

