/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPackageChooserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)JSPackageChooserDialog.class.getName());
    private Tree myTree;
    private DefaultTreeModel myModel;
    private final Project myProject;
    private final String myTitle;
    private final DirectoryIndex myIndex;
    private final GlobalSearchScope mySearchScope;

    public JSPackageChooserDialog(String title, Project project, GlobalSearchScope searchScope) {
        super(project, true);
        this.mySearchScope = searchScope;
        this.setTitle(title);
        this.myTitle = title;
        this.myProject = project;
        this.myIndex = DirectoryIndex.getInstance((Project)this.myProject);
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.createTreeModel();
        this.myTree = new Tree((TreeModel)this.myModel);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object object;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(PlatformIcons.PACKAGE_ICON);
                if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof VirtualFile) {
                    String name = JSPackageChooserDialog.this.myIndex.getPackageName((VirtualFile)object);
                    this.setText(name.length() > 0 ? StringUtil.getShortName((String)name) : IdeBundle.message((String)"node.default", (Object[])new Object[0]));
                }
                return this;
            }
        });
        this.myTree.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof VirtualFile) {
                    return ((VirtualFile)object).getName();
                }
                return "";
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                VirtualFile selection = JSPackageChooserDialog.this.getTreeSelection();
                if (selection != null) {
                    String name = JSPackageChooserDialog.this.myIndex.getPackageName(selection);
                    JSPackageChooserDialog.this.setTitle(JSPackageChooserDialog.this.myTitle + " - " + ("".equals(name) ? IdeBundle.message((String)"node.default.package", (Object[])new Object[0]) : name));
                } else {
                    JSPackageChooserDialog.this.setTitle(JSPackageChooserDialog.this.myTitle);
                }
            }
        });
        panel.add((Component)scrollPane, "Center");
        DefaultActionGroup group = this.createActionGroup((JComponent)this.myTree);
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        panel.add((Component)toolBar.getComponent(), "North");
        toolBar.getComponent().setAlignmentX(0.0f);
        return panel;
    }

    private DefaultActionGroup createActionGroup(JComponent component) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup temp = new DefaultActionGroup();
        NewPackageAction newPackageAction = new NewPackageAction();
        newPackageAction.enableInModalConext();
        newPackageAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("NewElement").getShortcutSet(), component);
        temp.add((AnAction)newPackageAction);
        group.add((AnAction)temp);
        return group;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    public String getDimensionServiceKey() {
        return "#com.intellij.ide.util.PackageChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    public String getSelectedPackage() {
        VirtualFile file = this.getTreeSelection();
        return file != null ? this.myIndex.getPackageName(file) : null;
    }

    public void selectPackage(String qualifiedName) {
        DefaultMutableTreeNode node = this.findNodeForPackage(qualifiedName);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
        }
    }

    @Nullable
    private VirtualFile getTreeSelection() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (VirtualFile)node.getUserObject();
    }

    private void createTreeModel() {
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        fileIndex.iterateContent(new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir.isDirectory() && JSPackageChooserDialog.this.mySearchScope.contains(fileOrDir) && fileIndex.isInSourceContent(fileOrDir)) {
                    JSPackageChooserDialog.this.addPackage(fileOrDir);
                }
                return true;
            }
        });
        TreeUtil.sort((DefaultTreeModel)this.myModel, (o1, o2) -> {
            DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)o1;
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)o2;
            VirtualFile element1 = (VirtualFile)n1.getUserObject();
            VirtualFile element2 = (VirtualFile)n2.getUserObject();
            return element1.getName().compareToIgnoreCase(element2.getName());
        });
    }

    @NotNull
    private DefaultMutableTreeNode addPackage(VirtualFile aPackage) {
        String qualifiedPackageName = this.myIndex.getPackageName(aPackage);
        VirtualFile parentPackage = aPackage.getParent();
        if (parentPackage == null || this.myIndex.getPackageName(parentPackage) == null) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.myModel.getRoot();
            if (qualifiedPackageName.length() == 0) {
                rootNode.setUserObject(aPackage);
                DefaultMutableTreeNode defaultMutableTreeNode = rootNode;
                if (defaultMutableTreeNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSPackageChooserDialog", "addPackage"));
                }
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode packageNode = this.findPackageNode(rootNode, qualifiedPackageName);
            if (packageNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
                if (defaultMutableTreeNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSPackageChooserDialog", "addPackage"));
                }
                return defaultMutableTreeNode;
            }
            packageNode = new DefaultMutableTreeNode(aPackage);
            rootNode.add(packageNode);
            DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSPackageChooserDialog", "addPackage"));
            }
            return defaultMutableTreeNode;
        }
        DefaultMutableTreeNode parentNode = this.addPackage(parentPackage);
        DefaultMutableTreeNode packageNode = this.findPackageNode(parentNode, qualifiedPackageName);
        if (packageNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSPackageChooserDialog", "addPackage"));
            }
            return defaultMutableTreeNode;
        }
        packageNode = new DefaultMutableTreeNode(aPackage);
        parentNode.add(packageNode);
        DefaultMutableTreeNode defaultMutableTreeNode = packageNode;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSPackageChooserDialog", "addPackage"));
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    private DefaultMutableTreeNode findPackageNode(DefaultMutableTreeNode rootNode, String qualifiedName) {
        DirectoryIndex index = this.myIndex;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            VirtualFile nodePackage = (VirtualFile)child.getUserObject();
            if (nodePackage == null || !Comparing.equal((String)index.getPackageName(nodePackage), (String)qualifiedName)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private DefaultMutableTreeNode findNodeForPackage(String qualifiedPackageName) {
        DirectoryIndex index = this.myIndex;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myModel.getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node;
            VirtualFile nodePackage;
            TreeNode o = enumeration.nextElement();
            if (!(o instanceof DefaultMutableTreeNode) || (nodePackage = (VirtualFile)(node = (DefaultMutableTreeNode)o).getUserObject()) == null || !Comparing.equal((String)index.getPackageName(nodePackage), (String)qualifiedPackageName)) continue;
            return node;
        }
        return null;
    }

    private void createNewPackage() {
        final VirtualFile selectedPackage = this.getTreeSelection();
        if (selectedPackage == null) {
            return;
        }
        final String newPackageName = Messages.showInputDialog((Project)this.myProject, (String)IdeBundle.message((String)"prompt.enter.a.new.package.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.package", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newPackageName == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)IdeBundle.message((String)"command.create.new.package", (Object[])new Object[0]), null, (Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        String newQualifiedName = JSPackageChooserDialog.this.myIndex.getPackageName(selectedPackage);
                        if (!Comparing.strEqual((String)newQualifiedName, (String)"")) {
                            newQualifiedName = newQualifiedName + ".";
                        }
                        newQualifiedName = newQualifiedName + newPackageName;
                        VirtualFile dir = selectedPackage.createChildDirectory((Object)this, newPackageName);
                        if (dir == null) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)JSPackageChooserDialog.this.myTree.getSelectionPath().getLastPathComponent();
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode();
                        newChild.setUserObject(dir);
                        node.add(newChild);
                        DefaultTreeModel model = (DefaultTreeModel)JSPackageChooserDialog.this.myTree.getModel();
                        model.nodeStructureChanged(node);
                        TreePath selectionPath = JSPackageChooserDialog.this.myTree.getSelectionPath();
                        TreePath path = selectionPath == null ? new TreePath(newChild.getPath()) : selectionPath.pathByAddingChild(newChild);
                        JSPackageChooserDialog.this.myTree.setSelectionPath(path);
                        JSPackageChooserDialog.this.myTree.scrollPathToVisible(path);
                        JSPackageChooserDialog.this.myTree.expandPath(path);
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showMessageDialog((Component)JSPackageChooserDialog.this.getContentPane(), (String)StringUtil.getMessage((Throwable)e), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        Messages.showMessageDialog((Component)JSPackageChooserDialog.this.getContentPane(), (String)StringUtil.getMessage((Throwable)e), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private class NewPackageAction
    extends AnAction {
        public NewPackageAction() {
            super(IdeBundle.message((String)"action.new.package", (Object[])new Object[0]), IdeBundle.message((String)"action.description.create.new.package", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        public void actionPerformed(AnActionEvent e) {
            JSPackageChooserDialog.this.createNewPackage();
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(JSPackageChooserDialog.this.getTreeSelection() != null);
        }

        public void enableInModalConext() {
            this.setEnabledInModalContext(true);
        }
    }
}

