/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JavaScriptFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    public JavaScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor", "<init>"));
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSFunctionSignatureChecker createFunctionSignatureChecker(PsiElement context) {
        JavaScriptFunctionSignatureChecker javaScriptFunctionSignatureChecker = new JavaScriptFunctionSignatureChecker(this.myTypeChecker){

            @Override
            public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor$1", "checkFunction"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor$1", "checkFunction"));
                }
            }

            @Override
            protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
            }
        };
        if (javaScriptFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor", "createFunctionSignatureChecker"));
        }
        return javaScriptFunctionSignatureChecker;
    }

    @Override
    public void visitComment(PsiComment comment) {
        this.checkFlowCommentWithinLanguageVersion(comment);
        super.visitComment(comment);
    }

    private void checkFlowCommentWithinLanguageVersion(PsiComment comment) {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)comment);
        if (optionHolder == null || optionHolder.isFlow || !optionHolder.isJavaScript()) {
            return;
        }
        int flagStart = CharArrayUtil.indexOf((CharSequence)comment.getNode().getChars(), (CharSequence)"@flow", (int)0);
        if (flagStart >= 0) {
            String message = JSBundle.message((String)"js.flowjs.flag.without.language.version", (Object[])new Object[0]);
            LocalQuickFix[] fixes = new LocalQuickFix[]{new ChangeLanguageLevelFix(JSLanguageLevel.FLOW)};
            this.myProblemReporter.registerProblem((PsiElement)comment, TextRange.from((int)flagStart, (int)"@flow".length()), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, fixes, IntentionAction.EMPTY_ARRAY);
        }
    }
}

