/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateInheritanceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String mySupertypeQname;
    private final boolean mySupertypeIsInterface;

    public CreateInheritanceFix(@Nullable PsiElement element, String supertypeQname, boolean supertypeIsInterface) {
        super(element);
        this.mySupertypeQname = supertypeQname;
        this.mySupertypeIsInterface = supertypeIsInterface;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "invoke"));
        }
        JSRefactoringUtil.addToSupersList((JSClass)startElement, this.mySupertypeQname, this.mySupertypeIsInterface);
        if (this.mySupertypeQname.contains(".") && !(startElement instanceof XmlBackedJSClass)) {
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            formatters.add(ImportUtils.insertImportStatements(startElement, Collections.singletonList(this.mySupertypeQname)));
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(startElement.getContainingFile()));
            FormatFixer.fixAll(formatters);
        }
    }

    @NotNull
    public String getText() {
        JSClass clazz = (JSClass)this.getStartElement();
        boolean implement = this.mySupertypeIsInterface && !clazz.isInterface();
        String string = JSBundle.message((String)(implement ? "javascript.fix.create.implements" : "javascript.fix.create.extends"), (Object[])new Object[]{clazz.getName(), this.mySupertypeQname});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix", "getFamilyName"));
        }
        return string;
    }
}

