/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.typescript.refactoring.extractMethod.TypeScriptExtractFunctionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsMethod;
    private boolean myIsProperty;

    public CreateJSFunctionIntentionAction(String name, boolean isMethod) {
        super(name, isMethod ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myIsMethod = isMethod;
    }

    @Override
    protected void applyFix(final Project project, final PsiElement psiElement, final PsiFile file, final Editor editor) {
        JSExtractFunctionHandler extractFunctionHandler = DialectDetector.isTypeScript(psiElement) ? new TypeScriptExtractFunctionHandler() : new JSExtractFunctionHandler();
        Pass<JSExtractFunctionHandler.IntroductionScope> callback = new Pass<JSExtractFunctionHandler.IntroductionScope>(){

            public void pass(JSExtractFunctionHandler.IntroductionScope scope) {
                CreateJSFunctionIntentionAction.this.myIsProperty = scope.getParent() instanceof JSObjectLiteralExpression;
                PsiElement anchor = JSExtractFunctionHandler.findFunctionAnchor(scope.getParent(), psiElement);
                CreateJSFunctionIntentionAction.this.doApplyFix(project, psiElement, file, editor, anchor);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.invokeInUnitTest(project, psiElement, file, editor, extractFunctionHandler, callback);
            return;
        }
        ExtractedFunctionSignatureGenerator generator = new ExtractedFunctionSignatureGenerator();
        JSReferenceExpression refExpr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSReferenceExpression.class);
        String functionName = null;
        if (refExpr != null) {
            functionName = refExpr.getReferenceName();
        }
        if (functionName == null) {
            functionName = "extracted";
        }
        if (this.getClassMemberOf(psiElement, file) != null) {
            this.doApplyFix(project, psiElement, file, editor, null);
            return;
        }
        final List<JSExtractFunctionHandler.IntroductionScope> scopes = extractFunctionHandler.findBases(psiElement);
        final boolean isActionScript = file.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        JSSignatureContext context = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public PsiElement getAnchor() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list = scopes;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$2", "getIntroductionScopes"));
                }
                return list;
            }
        };
        JSExtractFunctionHandler.IntroductionScope scope = extractFunctionHandler.getIntroductionScope(editor, generator, context, callback, functionName);
        if (scope != null) {
            this.doApplyFix(project, psiElement, file, editor, null);
        }
    }

    private void invokeInUnitTest(Project project, PsiElement psiElement, PsiFile file, Editor editor, JSExtractFunctionHandler extractFunctionHandler, Pass<JSExtractFunctionHandler.IntroductionScope> callback) {
        JSStatement type = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSStatement.class, (boolean)false);
        if (type != null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)type);
            if (docComment instanceof JSDocComment) {
                String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
                List<JSExtractFunctionHandler.IntroductionScope> scopes = extractFunctionHandler.findBases(psiElement);
                boolean testExecuted = false;
                for (JSExtractFunctionHandler.IntroductionScope scope : scopes) {
                    if (!scopePresentation.equals(scope.toString())) continue;
                    callback.pass((Object)scope);
                    testExecuted = true;
                    break;
                }
                assert (testExecuted) : "Scope with name " + scopePresentation + " not found";
            } else {
                super.applyFix(project, psiElement, file, editor);
            }
        } else {
            List<JSExtractFunctionHandler.IntroductionScope> scopes = extractFunctionHandler.findBases(psiElement);
            if (!scopes.isEmpty()) {
                callback.pass(ContainerUtil.getFirstItem(scopes));
            }
        }
    }

    @Nullable
    private PsiElement getClassMemberOf(PsiElement psiElement, PsiFile file) {
        if (!JSClassUtils.canHaveClasses(psiElement)) {
            return null;
        }
        Pair<JSReferenceExpression, PsiElement> pair = this.calculateAnchors(psiElement);
        if (pair.first != null && ((JSReferenceExpression)pair.first).getQualifier() != null) {
            return CreateJSFunctionIntentionAction.getType(((JSReferenceExpression)pair.first).getQualifier(), file);
        }
        return null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, PsiFile file, JSClass clazz, JSReferenceExpression referenceExpression) {
        if (this.myIsProperty) {
            createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            template.addTextSegment(createdMethodName);
            template.addTextSegment(": function ");
            return;
        }
        if (clazz != null) {
            if (createdMethodName.indexOf(46) != -1) {
                createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            }
            template.addTextSegment(JSClassUtils.createClassFunctionName(createdMethodName, (PsiElement)file));
            return;
        }
        if (DialectDetector.isActionScript((PsiElement)file) || DialectDetector.isTypeScript((PsiElement)file) && referenceExpression.getQualifier() == null || !this.myIsMethod) {
            template.addTextSegment("function ");
            template.addTextSegment(createdMethodName);
            return;
        }
        if (createdMethodName.indexOf(46) == -1) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix((PsiElement)file) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(" = function ");
    }

    @Override
    protected void addSemicolonSegment(Template template, PsiFile file) {
        if (this.myIsProperty) {
            template.addTextSegment(",");
        } else {
            super.addSemicolonSegment(template, file);
        }
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        PsiElement element = referenceExpression.getParent();
        JSArgumentList list = element instanceof JSCallExpression ? ((JSCallExpression)element).getArgumentList() : null;
        CreateJSFunctionIntentionAction.addParameters(template, list, (PsiElement)referenceExpression, file);
    }

    protected static void addParameters(Template template, @Nullable JSArgumentList list, PsiElement context, PsiFile file) {
        JSExpression[] expressions = list != null ? list.getArguments() : JSExpression.EMPTY_ARRAY;
        int paramCount = expressions.length;
        THashSet usedParameterNames = new THashSet();
        for (int i = 0; i < paramCount; ++i) {
            String typeName;
            JSExpression passedParameterValue;
            String var;
            if (i != 0) {
                template.addTextSegment(", ");
            }
            if ((var = (passedParameterValue = expressions[i]) instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : BasicIntroducedEntityInfoProvider.suggestCandidateName(passedParameterValue, context, null)) == null || var.length() == 0) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            String var1 = var;
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(var1);
            template.addVariable(var, (Expression)expression, (Expression)expression, true);
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
            if (holder == null || !holder.isTypeScript && !holder.isECMA4 || ((typeName = JSResolveUtil.getExpressionType(passedParameterValue, file)) == null || "null".equals(typeName)) && holder.isTypeScript) continue;
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(typeName, template, var1, context);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file, true);
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @Nullable PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (superRefExpression == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier((JSExpression)superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
        template.addTextSegment("\n");
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        super.buildTemplate(template, referenceExpression, staticContext, file, anchorParent);
        if (this.myIsMethod && !JSClassUtils.canHaveClasses((PsiElement)file)) {
            this.addSemicolonSegment(template, file);
        }
    }
}

