/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSetElementVisibilityFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final JSAttributeList.AccessType myVisibility;
    private final String myNamespace;

    public JSSetElementVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "<init>"));
        }
        super((PsiElement)method);
        this.myVisibility = visibility;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getText() {
        JSAttributeListOwner myClassOrMethod = (JSAttributeListOwner)this.getStartElement();
        if (myClassOrMethod == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "getText"));
            }
            return "";
        }
        String string = JSInsertModifierFix.getSetModifierText(myClassOrMethod, this.myVisibility != null ? JSFormatUtil.formatVisibility(this.myVisibility, (PsiElement)myClassOrMethod) : this.myNamespace);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix", "invoke"));
        }
        JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)startElement, this.myVisibility, this.myNamespace);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

