/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.OutputFilesHandler;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class JSOutputFilesHandler
implements OutputFilesHandler {
    private static final String GENERATED_FILES_LIB_NAME = "Generated files";
    private static final Key<DelayedMergingGeneratedFilesUpdater> DELAYED_MERGING_GENERATED_FILES_UPDATER_KEY = Key.create((String)"DELAYED_MERGING_GENERATED_FILES_UPDATER");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRefresh(DataContext dataContext, VirtualFile file, TaskOptions options, List<VirtualFile> outputFiles) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        outputFiles = ContainerUtil.filter(outputFiles, virtualFile -> virtualFile.getFileType() == JavaScriptFileType.INSTANCE);
        if (project != null) {
            DelayedMergingGeneratedFilesUpdater updater = (DelayedMergingGeneratedFilesUpdater)DELAYED_MERGING_GENERATED_FILES_UPDATER_KEY.get((UserDataHolder)project);
            if (updater == null) {
                Object object = LOCK;
                synchronized (object) {
                    updater = (DelayedMergingGeneratedFilesUpdater)DELAYED_MERGING_GENERATED_FILES_UPDATER_KEY.get((UserDataHolder)project);
                    if (updater == null) {
                        updater = new DelayedMergingGeneratedFilesUpdater(project);
                        DELAYED_MERGING_GENERATED_FILES_UPDATER_KEY.set((UserDataHolder)project, (Object)updater);
                    }
                }
            }
            updater.update(outputFiles);
        }
    }

    public static void updateGeneratedLib(@NotNull Project project, @NotNull List<VirtualFile> outputFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler", "updateGeneratedLib"));
        }
        if (outputFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler", "updateGeneratedLib"));
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        ScriptingLibraryModel libraryModel = libraryManager.getLibraryByName(GENERATED_FILES_LIB_NAME);
        if (libraryModel == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (outputFiles == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler", "lambda$updateGeneratedLib$1"));
                }
                libraryManager.createLibrary(GENERATED_FILES_LIB_NAME, VfsUtilCore.toVirtualFileArray((Collection)outputFiles), VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PROJECT, false);
                libraryManager.commitChanges();
            });
            return;
        }
        if (libraryModel.getSourceFiles().containsAll(outputFiles)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (outputFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler", "lambda$updateGeneratedLib$2"));
            }
            THashSet sourceFiles = new THashSet((Collection)libraryModel.getSourceFiles());
            sourceFiles.addAll(outputFiles);
            Set compactFiles = libraryModel.getCompactFiles();
            Set docUrls = libraryModel.getDocUrls();
            libraryManager.updateLibrary(GENERATED_FILES_LIB_NAME, GENERATED_FILES_LIB_NAME, (VirtualFile[])ArrayUtil.toObjectArray((Collection)sourceFiles, VirtualFile.class), (VirtualFile[])ArrayUtil.toObjectArray((Collection)compactFiles, VirtualFile.class), (String[])ArrayUtil.toObjectArray((Collection)docUrls, String.class));
            libraryManager.commitChanges();
        });
    }

    private static class DelayedMergingGeneratedFilesUpdater {
        private static final int DELAY_MILLIS = 500;
        private final Project myProject;
        private final BlockingQueue<VirtualFile> myQueue;
        private final Alarm myAlarm;
        private final AtomicInteger myPendingUpdates;

        public DelayedMergingGeneratedFilesUpdater(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler$DelayedMergingGeneratedFilesUpdater", "<init>"));
            }
            this.myQueue = new LinkedBlockingQueue<VirtualFile>();
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.myPendingUpdates = new AtomicInteger(0);
            this.myProject = project;
        }

        public void update(@NotNull List<VirtualFile> outputFiles) {
            if (outputFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "com/intellij/lang/javascript/watcher/JSOutputFilesHandler$DelayedMergingGeneratedFilesUpdater", "update"));
            }
            if (outputFiles.isEmpty()) {
                return;
            }
            this.myQueue.addAll(outputFiles);
            int beforePendingUpdates = this.myPendingUpdates.incrementAndGet();
            if (beforePendingUpdates == 1) {
                this.reschedule(beforePendingUpdates, 3);
            }
        }

        private void reschedule(int beforePendingUpdates, int reschedulingRestCount) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                int currentPendingUpdates = this.myPendingUpdates.get();
                if (beforePendingUpdates < currentPendingUpdates && reschedulingRestCount > 0) {
                    this.reschedule(currentPendingUpdates, reschedulingRestCount - 1);
                } else {
                    this.myPendingUpdates.set(0);
                    int size = this.myQueue.size();
                    if (size == 0) {
                        return;
                    }
                    ArrayList list = ContainerUtil.newArrayListWithCapacity((int)size);
                    this.myQueue.drainTo(list, size);
                    JSOutputFilesHandler.updateGeneratedLib(this.myProject, list);
                }
            }, 500, ModalityState.NON_MODAL);
        }
    }
}

