/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsx;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptParserDefinition;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public class JSXHarmonyParserDefinition
extends JavascriptParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        JSFlexAdapter jSFlexAdapter = new JSFlexAdapter(JSXHarmonyLanguageDialect.DIALECT_OPTION_HOLDER);
        if (jSFlexAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsx/JSXHarmonyParserDefinition", "createLexer"));
        }
        return jSFlexAdapter;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JSStubElementTypes.JSX_FILE;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                new ES6Parser(JavaScriptSupportLoader.JSX_HARMONY, builder).parseJS(root);
                ASTNode aSTNode = builder.getTreeBuilt();
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsx/JSXHarmonyParserDefinition$1", "parse"));
                }
                return aSTNode;
            }
        };
        if (psiParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsx/JSXHarmonyParserDefinition", "createParser"));
        }
        return psiParser;
    }
}

