/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceFilter;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptCompilerService
extends JSLanguageServiceBase
implements JSLanguageService {
    @NotNull
    public static TypeScriptCompilerService getDefaultService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getDefaultService"));
        }
        TypeScriptCompilerService typeScriptCompilerService = (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptServerServiceImpl.class);
        if (typeScriptCompilerService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getDefaultService"));
        }
        return typeScriptCompilerService;
    }

    @Nullable
    public static TypeScriptCompilerService getServiceForFile(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getServiceForFile"));
        }
        return (TypeScriptCompilerService)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "lambda$getServiceForFile$0"));
            }
            List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
            for (JSLanguageService service : services) {
                if (!(service instanceof TypeScriptCompilerService) || !service.isAcceptable(file) || !JSLanguageServiceFilter.checkAvailable(project, service, file)) continue;
                return (TypeScriptCompilerService)service;
            }
            return null;
        });
    }

    public static void restartServices(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "restartServices"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.restartServices(project, true);
    }

    public static void restartServices(@NotNull Project project, boolean recreateToolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "restartServices"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.terminateStartedProcess(recreateToolWindow);
            }
        }));
    }

    public static void sendCleanCommand(Project project, TypeScriptServiceCommandClean command) {
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.sendCleanCommandToCompiler(command);
            }
        }));
    }

    public static void addFileToCompileQueue(Project project, @NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "addFileToCompileQueue"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "lambda$addFileToCompileQueue$4"));
            }
            List<VirtualFile> toProcess = files.stream().filter(el -> service.isAcceptable((VirtualFile)el) && JSLanguageServiceFilter.checkAvailable(project, service, el)).collect(Collectors.toList());
            service.addFileToCompileQueue(toProcess);
        }));
    }

    public abstract void flushCompileQueue();

    public static void processForServices(@NotNull Project project, Consumer<TypeScriptCompilerService> consumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "processForServices"));
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        services.forEach(service -> {
            if (service instanceof TypeScriptCompilerService) {
                consumer.consume((Object)((TypeScriptCompilerService)service));
            }
        });
    }

    public static List<TypeScriptCompilerService> getAll(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getAll"));
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        return services.stream().filter(el -> el instanceof TypeScriptCompilerService).map(el -> (TypeScriptCompilerService)el).collect(Collectors.toList());
    }

    public static void initToolWindow(Project project) {
        if (!TypeScriptLanguageServiceUtil.checkProject(project) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JSLanguageServiceToolWindowManager manager = TypeScriptToolWindowProvider.getToolWindow(project);
        if (manager == null) {
            return;
        }
        manager.lazyInit((Condition<JSLanguageServiceToolWindowManager>)((Condition)el -> TypeScriptLanguageServiceUtil.checkProject(project) && TypeScriptCompilerSettings.getSettings(project).isCompilerEnabled()));
    }

    public TypeScriptCompilerService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "<init>"));
        }
        super(project);
    }

    public abstract void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig var1);

    protected abstract void addFileToCompileQueue(@NotNull List<VirtualFile> var1);

    public abstract Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile var1, @NotNull PsiFile var2, @NotNull Document var3, int var4);

    @Nullable
    public abstract Future<Boolean> update(JSLanguageServiceUpdateContext var1);

    @Nullable
    public abstract TypeScriptServerServiceSettings getServiceSettings();
}

