/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ES6ImportOptimizer
implements ImportOptimizer {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        DirectoryInfo directoryInfo;
        if (!file.isValid() || DumbService.getInstance((Project)file.getProject()).isDumb()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)file.getProject());
        JpsModuleSourceRootType sourceRootType = directoryIndex.getSourceRootType(directoryInfo = directoryIndex.getInfoForFile(file.getVirtualFile()));
        if (JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        Collection<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)file);
        if (declarations.isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        for (ES6ImportDeclaration declaration : declarations) {
            ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.getInfo(declaration);
            if (!info.isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration) == null) continue;
            infos.add(info);
        }
        List<String> importTexts = this.buildNewImportsText(file, infos);
        Project project = file.getProject();
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            if (document != null) {
                manager.commitDocument(document);
            }
            HashMap prevDeclarations = ContainerUtil.newHashMap();
            for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
                ES6ImportDeclaration declaration = info.getDeclaration();
                prevDeclarations.put(declaration, Pair.create(ES6ImportOptimizer.getPrevComments(document, declaration), (Object)ES6ImportOptimizer.getLineComment(document, declaration)));
            }
            if (!importTexts.isEmpty()) {
                String text = StringUtil.join((Collection)importTexts, (String)"");
                PsiFile newFile = JSChangeUtil.createJSFileFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)file));
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)newFile);
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                assert (item != null);
                ES6ImportDeclaration declaration = item.getDeclaration();
                List<PsiElement> comments = ES6ImportOptimizer.getPrevComments(document, declaration);
                ES6ImportDeclaration anchor = declaration;
                if (comments.size() > 0) {
                    anchor = comments.get(0);
                }
                PsiElement siblingBeforeAnchor = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class});
                PsiElement parent = anchor.getParent();
                PsiElement element = SharedImplUtil.addRange((PsiElement)parent, (PsiElement)newFile.getFirstChild(), (PsiElement)newFile.getLastChild(), (ASTNode)anchor.getNode(), (Boolean)Boolean.TRUE);
                if (element instanceof PsiComment && !(siblingBeforeAnchor instanceof PsiComment)) {
                    JSChangeUtil.addWs(parent.getNode(), element.getNode(), "\n");
                }
            }
            for (int i = 0; i < infos.size(); ++i) {
                ES6UnusedImportsHelper.UnusedInfo info;
                info = (ES6UnusedImportsHelper.UnusedInfo)infos.get(i);
                boolean isFirst = i == 0;
                ES6ImportDeclaration declaration = info.getDeclaration();
                Pair pair = (Pair)prevDeclarations.get(declaration);
                List prevComments = (List)pair.first;
                PsiElement sameLineEndComment = (PsiElement)pair.second;
                boolean hasComments = prevComments.size() > 0;
                ES6ImportDeclaration beforeElement = hasComments ? (PsiElement)prevComments.get(0) : declaration;
                PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
                ES6ImportOptimizer.deleteSiblingWhitespaceBetweenImports((PsiElement)beforeElement, afterElement, !isFirst, true);
                if (hasComments || sameLineEndComment != null) {
                    declaration.getParent().deleteChildRange((PsiElement)beforeElement, afterElement);
                    continue;
                }
                declaration.delete();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
        }
        return runnable;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports((PsiElement)file);
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        ArrayList toProcessInfos = ContainerUtil.newArrayList(infos);
        ES6ImportOptimizer.sortByModuleName(file, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection mergedImports;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList sideEffectImportWithComments = ContainerUtil.newArrayList();
                ES6ImportOptimizer.addSideEffectImport(file, document, sideEffectImportWithComments, info);
                ES6ImportOptimizer.fillImportsWithNewLines(importsResult, declaration, sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            ArrayList currentImports = ContainerUtil.newArrayList();
            if (merge) {
                this.processMergedImports(file, document, currentImports, fromText, mergedImports);
            } else {
                HashSet visitedBindingNames = ContainerUtil.newHashSet();
                HashSet visitedSpecifierNames = ContainerUtil.newHashSet();
                for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                    List<String> importBodyText = this.getImportBodyText(file, document, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText, visitedBindingNames, visitedSpecifierNames);
                    currentImports.addAll(importBodyText);
                }
            }
            ES6ImportOptimizer.fillImportsWithNewLines(importsResult, declaration, currentImports);
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        return arrayList;
    }

    private static void sortByModuleName(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)file);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator((PsiElement)file);
        ContainerUtil.sort(infos, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    private static void fillImportsWithNewLines(@NotNull List<String> importsResult, @NotNull ES6ImportDeclaration declaration, @NotNull List<String> elements) {
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "fillImportsWithNewLines"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "fillImportsWithNewLines"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "fillImportsWithNewLines"));
        }
        if (elements.isEmpty()) {
            return;
        }
        if (importsResult.size() > 0) {
            List<PsiElement> whitespaces = ES6ImportOptimizer.getWhitespacesBeforePrevImport((PsiElement)declaration);
            if (whitespaces.size() > 0) {
                importsResult.addAll(ES6ImportOptimizer.getPsiElementsAsStrings(whitespaces));
            } else {
                importsResult.add("\n");
            }
        }
        for (int i = 0; i < elements.size(); ++i) {
            String current = elements.get(i);
            if (i > 0) {
                importsResult.add("\n");
            }
            importsResult.add(current);
        }
    }

    protected void processMergedImports(@NotNull PsiFile file, @Nullable Document document, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processMergedImports"));
        }
        importsResult.addAll(this.getImportBodyText(file, document, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @Nullable Document document, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String name = declaration.getImportModuleText();
        if (!StringUtil.isEmpty((String)name)) {
            List<PsiElement> prevComments = ES6ImportOptimizer.getPrevComments(document, declaration);
            importsResult.addAll(ES6ImportOptimizer.getPsiElementsAsStrings(prevComments));
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ES6ImportOptimizer.addFromPartWithoutKeyword(file, StringUtil.unquoteString((String)name), builder);
            ES6ImportOptimizer.addSameLineComments(builder, ES6ImportOptimizer.getPsiElementsAsStrings(ContainerUtil.createMaybeSingletonList((Object)ES6ImportOptimizer.getLineComment(document, declaration))));
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        return linkedMultiMap;
    }

    private static boolean isSuppressedUnused(ES6ImportExportDeclaration declaration) {
        return SuppressionUtil.isSuppressedInStatement((PsiElement)declaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        HashSet bindings = ContainerUtil.newHashSet();
        HashSet specifiers = ContainerUtil.newHashSet();
        return this.getImportBodyText(file, document, mergedImports, fromPart, bindings, specifiers);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedBindingNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedBindingNames", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedSpecifierNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedSpecifierNames", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        ArrayList listOfImports = ContainerUtil.newArrayList();
        ArrayList bindings = ContainerUtil.newArrayList();
        ArrayList specifiers = ContainerUtil.newArrayList();
        ArrayList prevCommentsToProcess = ContainerUtil.newArrayList();
        HashMap lineCommentsToProcess = ContainerUtil.newHashMap();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = ES6ImportOptimizer.getLineComment(document, declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(ES6ImportOptimizer.getPrevComments(document, declaration));
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)file).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator((PsiElement)file);
            ContainerUtil.sort((List)specifiers, comparator);
        }
        String importPrefix = this.getImportPrefix(mergedImports);
        boolean needCommaBeforeBinding = false;
        boolean lastIsAll = false;
        StringBuilder importBody = new StringBuilder();
        ArrayList lineCommentsForCurrentImport = ContainerUtil.newArrayList();
        for (ES6ImportedBinding binding : bindings) {
            PsiElement comment;
            if (!visitedBindingNames.add(binding.getName())) continue;
            if (needCommaBeforeBinding) {
                ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
                ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getPsiElementsAsStrings(lineCommentsForCurrentImport));
                String resultText = importPrefix + importBody.toString();
                listOfImports.add(resultText);
                importBody.setLength(0);
                lineCommentsForCurrentImport.clear();
            } else {
                needCommaBeforeBinding = true;
            }
            ES6ImportDeclaration declaration = binding.getDeclaration();
            if (declaration != null && (comment = (PsiElement)lineCommentsToProcess.remove(declaration)) != null) {
                lineCommentsForCurrentImport.add(comment);
            }
            importBody.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getPsiElementsAsStrings(lineCommentsForCurrentImport));
            listOfImports.add(importPrefix + importBody.toString());
            needCommaBeforeBinding = false;
            importBody.setLength(0);
            lineCommentsForCurrentImport.clear();
        }
        boolean needOpenSpecifierList = true;
        boolean needCommaBeforeSpecifier = false;
        for (ES6ImportSpecifier specifier : specifiers) {
            String name;
            PsiElement comment;
            ES6ImportDeclaration declaration = specifier.getDeclaration();
            if (declaration != null && (comment = (PsiElement)lineCommentsToProcess.remove(declaration)) != null) {
                lineCommentsForCurrentImport.add(comment);
            }
            if (!visitedSpecifierNames.add(name = specifier.getDeclaredName())) continue;
            if (needOpenSpecifierList) {
                needOpenSpecifierList = false;
                if (needCommaBeforeBinding) {
                    importBody.append(", ");
                }
                importBody.append('{');
            }
            if (needCommaBeforeSpecifier) {
                importBody.append(", ");
            } else {
                needCommaBeforeSpecifier = true;
            }
            importBody.append(specifier.getText());
        }
        if (!needOpenSpecifierList) {
            importBody.append('}');
        }
        if (!StringUtil.isEmpty((CharSequence)importBody)) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getPsiElementsAsStrings(lineCommentsForCurrentImport));
            listOfImports.add(importPrefix + importBody.toString());
        }
        List<String> comments = ES6ImportOptimizer.getPsiElementsAsStrings(prevCommentsToProcess);
        return ContainerUtil.concat(comments, (List)listOfImports);
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration);
        ES6ImportedBinding[] currentBindings = declaration.getImportedBindings();
        ES6ImportSpecifier[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedBindings = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedBindings();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedSpecifiers();
        bindings.addAll(Arrays.stream(currentBindings).filter(el -> !unusedBindings.contains(el)).collect(Collectors.toList()));
        specifiers.addAll(Arrays.stream(currentSpecifiers).filter(el -> !unusedSpecifiers.contains(el)).collect(Collectors.toList()));
    }

    private static List<String> getPsiElementsAsStrings(Collection<PsiElement> toProcess) {
        return toProcess.stream().map(el -> el.getText()).collect(Collectors.toList());
    }

    private static void addSameLineComments(@NotNull StringBuilder importBody, @NotNull Collection<String> sameLineComments) {
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSameLineComments"));
        }
        if (sameLineComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sameLineComments", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSameLineComments"));
        }
        if (!sameLineComments.isEmpty()) {
            importBody.append(" ");
            importBody.append(StringUtil.join(sameLineComments, (String)" "));
        }
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        if ("import " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        return "import ";
    }

    private static void addFromPart(PsiFile file, String fromPart, StringBuilder importBody) {
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(file, fromPart, importBody);
    }

    @NotNull
    private static List<PsiElement> getPrevComments(@Nullable Document document, @NotNull ES6ImportDeclaration declaration) {
        PsiElement nextPrev;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
        }
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        if (document == null || prev == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
            }
            return list;
        }
        if (!ES6ImportOptimizer.isSameLineElement(document, prev, (PsiElement)declaration, 1) && !ES6ImportOptimizer.isSameLineElement(document, prev, (PsiElement)declaration, 0)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
            }
            return list;
        }
        ArrayList comments = ContainerUtil.newArrayList();
        while (prev instanceof PsiComment && ((nextPrev = PsiTreeUtil.skipSiblingsBackward((PsiElement)prev, (Class[])new Class[]{PsiWhiteSpace.class})) == null || nextPrev instanceof PsiComment || !ES6ImportOptimizer.isSameLineElement(document, prev, nextPrev, 0))) {
            comments.add(0, prev);
            prev = nextPrev;
        }
        ArrayList arrayList = comments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
        }
        return arrayList;
    }

    private static PsiElement getLineComment(@Nullable Document document, @NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getLineComment"));
        }
        if (document == null) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        if (next instanceof PsiComment) {
            boolean isSameLineElements = ES6ImportOptimizer.isSameLineElement(document, (PsiElement)declaration, next, 0);
            return isSameLineElements ? next : null;
        }
        return null;
    }

    private static boolean isSameLineElement(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement, int offsetLine) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "isSameLineElement"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "isSameLineElement"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "isSameLineElement"));
        }
        int startElementEndOffset = document.getLineNumber(startElement.getTextRange().getEndOffset());
        int endElementStartOffset = document.getLineNumber(endElement.getTextRange().getStartOffset());
        return endElementStartOffset == offsetLine + startElementEndOffset;
    }

    private static void addFromPartWithoutKeyword(@NotNull PsiFile file, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(JSCodeStyleSettings.getSemicolon(file));
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement beforeElement, PsiElement after, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling;
        if (deleteBefore) {
            sibling = beforeElement;
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!ES6ImportOptimizer.prevIsAcceptable(prev)) continue;
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = after;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                PsiElement nextSibling = sibling.getNextSibling();
                if (!ES6ImportOptimizer.nextIsAcceptable(nextSibling)) continue;
                sibling.delete();
            }
        }
    }

    public static List<PsiElement> getWhitespacesBeforePrevImport(PsiElement declaration) {
        PsiElement sibling = declaration;
        ArrayList siblings = ContainerUtil.newArrayList();
        while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
            siblings.add(0, sibling);
            PsiElement prev = sibling.getPrevSibling();
            if (!(prev instanceof ES6ImportDeclaration)) continue;
            return siblings;
        }
        return ContainerUtil.emptyList();
    }

    public static boolean prevIsAcceptable(PsiElement prev) {
        return prev == null || prev instanceof ES6ImportDeclaration || prev instanceof PsiWhiteSpace || prev instanceof PsiComment;
    }

    public static boolean nextIsAcceptable(PsiElement prev) {
        return prev == null || prev instanceof ES6ImportDeclaration || prev instanceof PsiWhiteSpace;
    }
}

