/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.typescript.intentions.TypeScriptAddAugmentationImportFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class TypeScriptMissingAugmentationImportInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptMissingAugmentationImportInspection.calcShortNameFromClass(TypeScriptMissingAugmentationImportInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection$1", "visitJSReferenceExpression"));
                }
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (optionHolder == null || !optionHolder.isTypeScript) {
                    return;
                }
                JSExpression qualifier = node.getQualifier();
                if (qualifier == null) {
                    return;
                }
                TypeScriptMissingAugmentationImportInspection.processReferenceExpression(holder, node);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void processReferenceExpression(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "processReferenceExpression"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "processReferenceExpression"));
        }
        PsiElement module = TypeScriptPsiUtil.findExternalModule((PsiElement)node);
        if (module == null) {
            return;
        }
        String name = TypeScriptAddAugmentationImportFix.getImportedModuleName((PsiElement)node);
        if (name == null) {
            return;
        }
        TypeScriptMissingAugmentationImportInspection.registerProblem(name, holder, node);
    }

    private static void registerProblem(@NotNull String name, @NotNull ProblemsHolder holder, @NotNull JSReferenceExpression context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "registerProblem"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "registerProblem"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection", "registerProblem"));
        }
        PsiElement element = context.getReferenceNameElement();
        assert (element != null);
        holder.registerProblem(element, JSBundle.message((String)"typescript.missing.augmentation.import", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TypeScriptAddAugmentationImportFix((PsiElement)context, name)});
    }
}

