/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddAugmentationImportFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    @NotNull
    private final String myName;

    public TypeScriptAddAugmentationImportFix(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "<init>"));
        }
        super(context);
        this.myName = name;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = TypeScriptAddAugmentationImportFix.getFixText(this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getText"));
        }
        return string;
    }

    @NotNull
    public static String getFixText(String name) {
        String string = "Import augmentation " + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getFixText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "invoke"));
        }
        PsiFile externalModule = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement);
        if (externalModule == null) {
            return;
        }
        PsiFile placePsiFile = startElement.getContainingFile();
        if (placePsiFile == null) {
            return;
        }
        String externalModuleName = TypeScriptAddAugmentationImportFix.getQuotedModuleName(project, startElement, placePsiFile, externalModule);
        if (externalModuleName == null) {
            return;
        }
        TypeScriptAddImportExecutor executor = new TypeScriptAddImportExecutor(externalModule.getName(), null, startElement);
        executor.createImportOrUseExisting((PsiElement)externalModule, externalModuleName, ES6ImportPsiUtil.ImportType.BARE);
    }

    private static String getQuotedModuleName(@NotNull Project project, @NotNull PsiElement context, @NotNull PsiFile placePsiFile, @NotNull PsiFile augmentationModule) {
        VirtualFile moduleDirectory;
        VirtualFile directoryToCalcModuleName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getQuotedModuleName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getQuotedModuleName"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getQuotedModuleName"));
        }
        if (augmentationModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "augmentationModule", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getQuotedModuleName"));
        }
        VirtualFile dstFile = augmentationModule.getVirtualFile();
        Pair<VirtualFile, VirtualFile> libraryDirectory = TypeScriptAutoImportUtil.findParentLibraryDirectory(project, dstFile, TypeScriptAutoImportUtil.NODE_MODULES);
        if (libraryDirectory != null && (directoryToCalcModuleName = TypeScriptAutoImportUtil.getDirectoryToCalcModuleNameInNodeModules(placePsiFile, moduleDirectory = (VirtualFile)libraryDirectory.first)) != null) {
            TypeScriptAutoImportUtil.ModuleInfo info = new TypeScriptAutoImportUtil.ModuleInfo(VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, context);
            return info.getPath();
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        TypeScriptConfig config = TypeScriptConfigService.Provider.getConfig(project, placeFile);
        TypeScriptAutoImportUtil.ModuleInfo moduleInfo = TypeScriptAutoImportUtil.getExternalModuleNameForFile(project, config, placeFile, placePsiFile, dstFile, context, false);
        return moduleInfo == null ? null : moduleInfo.getPath();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "isAvailable"));
        }
        return TypeScriptAddAugmentationImportFix.getImportedModuleName(startElement) != null;
    }

    public static String getImportedModuleName(@NotNull PsiElement startElement) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getImportedModuleName"));
        }
        PsiFile module = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement);
        if (module == null) {
            return null;
        }
        String externalModuleName = TypeScriptAddAugmentationImportFix.getQuotedModuleName(startElement.getProject(), startElement, startElement.getContainingFile(), module);
        if (externalModuleName == null) {
            return null;
        }
        PsiElement placeModule = TypeScriptAutoImportUtil.getScopeToAddImport(startElement, true);
        if (placeModule == null) {
            return null;
        }
        if (TypeScriptAutoImportUtil.findExistingES6Import(placeModule, (PsiElement)module, externalModuleName, false) != null) {
            return null;
        }
        return externalModuleName;
    }

    @Nullable
    public static PsiFile getAugmentationModule(@NotNull PsiElement startElement) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix", "getAugmentationModule"));
        }
        if (!(startElement instanceof JSReferenceExpression)) {
            return null;
        }
        Collection<PsiElement> elements = JSResolveResult.toElements(((JSReferenceExpression)startElement).multiResolve(false));
        if (elements.size() != 1) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        PsiElement module = TypeScriptPsiUtil.findExternalModule(item);
        if (!(module instanceof TypeScriptModule) || !((TypeScriptModule)module).isAugmentation()) {
            return null;
        }
        return module.getContainingFile();
    }
}

