/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptAddFileToConfigFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptAddFileToConfigFix.class);
    @NotNull
    private final String myFileName;

    public TypeScriptAddFileToConfigFix(@NotNull JSElement jsElement, @NotNull PsiElement element) {
        if (jsElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsElement", "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix", "<init>"));
        }
        this.registerElementRefForFix((PsiElement)jsElement, null);
        PsiFile file = element.getContainingFile();
        this.myFileName = file.getName();
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Collection<TypeScriptConfig> includes = TypeScriptConfigService.Provider.getConfigInclude(project, virtualFile);
        for (TypeScriptConfig include : includes) {
            if (!include.isDirectoryBased()) continue;
            return false;
        }
        return !includes.isEmpty();
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, PsiElement reference, PsiFile file, Editor editor) {
        JSElement el = (JSElement)reference;
        if (!(el instanceof PsiPolyVariantReference)) {
            return;
        }
        Object[] results = ((PsiPolyVariantReference)el).multiResolve(false);
        if (results.length == 0) {
            return;
        }
        ResolveResult item = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
        if (!(item instanceof JSResolveResult)) {
            return;
        }
        JSResolveResult jsResolveResult = (JSResolveResult)item;
        PsiElement element = jsResolveResult.getElement();
        VirtualFile virtualFile = file.getVirtualFile();
        Collection<TypeScriptConfig> includes = TypeScriptConfigService.Provider.getConfigInclude(project, virtualFile);
        if (includes.isEmpty()) {
            return;
        }
        assert (element != null);
        PsiFile psiFileForResolvedElement = element.getContainingFile();
        VirtualFile virtualFileToAdd = psiFileForResolvedElement.getVirtualFile();
        for (TypeScriptConfig include : includes) {
            if (TypeScriptConfigUtil.addVirtualFileToConfigFiles(project, virtualFileToAdd, include)) continue;
            LOGGER.error("Cannot add reference to tsconfig.json \n" + include.toString());
        }
    }

    @Nls
    @NotNull
    public String getName() {
        String string = TypeScriptAddFileToConfigFix.getMessageText(this.myFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix", "getName"));
        }
        return string;
    }

    public static String getMessageText(String fileName) {
        return String.format("Add file '%s' to tsconfig.json", fileName);
    }
}

