/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.modules.TypeScriptSimpleModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileModuleReference
extends TypeScriptSimpleModuleReference {
    public TypeScriptFileModuleReference(String text, int i, TextRange textRange, FileReferenceSet refSet) {
        super(text, i, textRange, refSet);
    }

    @Override
    protected void processResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "processResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "processResolveInContext"));
        }
        super.processResolveInContext(referenceText, context, results, caseSensitive);
        this.innerResolveAdditionalRoots(referenceText, context, results, caseSensitive);
    }

    private void innerResolveAdditionalRoots(@NotNull String s, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        FileReferenceSet set;
        String requiredModuleName;
        boolean isRelative;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveAdditionalRoots"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveAdditionalRoots"));
        }
        boolean startsWithDot = this.getText().startsWith(".");
        if (!startsWithDot && context.isDirectory() && (isRelative = (requiredModuleName = (set = this.getFileReferenceSet()).getPathString()).startsWith("."))) {
            Collection<PsiFileSystemItem> dirs;
            PsiElement element = set.getElement();
            Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigFiles(element.getProject());
            if (configs.isEmpty() || !TypeScriptFileModuleReference.configsIncludeRootDirs(configs)) {
                return;
            }
            TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(element.getContainingFile().getOriginalFile());
            if (config != null && (dirs = config.getRootDirs()).contains(context)) {
                for (PsiFileSystemItem dir : dirs) {
                    if (dir == context) continue;
                    super.processResolveInContext(s, dir, results, caseSensitive);
                }
            }
        }
    }

    private static boolean configsIncludeRootDirs(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "configsIncludeRootDirs"));
        }
        for (TypeScriptConfig config : configs) {
            if (config.getRootDirs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ResolveResult resolveDirectory(@NotNull PsiDirectory element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "resolveDirectory"));
        }
        Project project = this.getElement().getProject();
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor processor = new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project);
        return JSExactFileReference.resolveForNpmPackages((PsiElement)element, processor);
    }
}

