/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleTextReference
implements PsiPolyVariantReference,
JSTextReference.JSDeclarationModuleReference,
JSModuleBaseReference {
    @NotNull
    private final String myReferenceText;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Project myProject;
    private final int myOffset;

    public TypeScriptModuleTextReference(@NotNull Project project, @NotNull PsiElement element, @NotNull String text, int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "<init>"));
        }
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myElement = element;
        this.myProject = project;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "getElement"));
        }
        return psiElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.getCanonicalText().length());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return JSResolveResult.resolve(results);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "bindToElement"));
        }
        return element instanceof PsiNamedElement ? this.handleElementRename(((PsiNamedElement)element).getName()) : element;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myReferenceText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.myProject).resolveWithCaching((PsiPolyVariantReference)this, (el, incomplete) -> this.doResolve(this.getElement().getContainingFile()), false, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof TypeScriptModule && JSReferenceUtil.isReferenceTo(this, this.myReferenceText, element);
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected ResolveResult[] doResolve(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "doResolve"));
        }
        return TypeScriptUtil.findExternalModule(psiFile.getOriginalFile(), this.getCanonicalText(), this.myProject);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "getProject"));
        }
        return project;
    }
}

