/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfigImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptConfigBase
implements TypeScriptConfig {
    private final NotNullLazyValue<Collection<VirtualFile>> myTypesDirectories = new NotNullLazyValue<Collection<VirtualFile>>(){

        @NotNull
        protected Collection<VirtualFile> compute() {
            Collection<String> types = TypeScriptConfigBase.this.getTypes();
            Collection<VirtualFile> roots = TypeScriptConfigBase.this.getTypeRoots();
            if (types.isEmpty() || roots.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase$1", "compute"));
                }
                return list;
            }
            ArrayList typesDirectories = ContainerUtil.newArrayList();
            for (VirtualFile virtualFile : roots) {
                for (String type : types) {
                    VirtualFile child = virtualFile.findChild(type);
                    if (child == null || !child.isDirectory()) continue;
                    typesDirectories.add(child);
                }
            }
            ArrayList arrayList = typesDirectories;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase$1", "compute"));
            }
            return arrayList;
        }
    };

    TypeScriptConfigBase() {
    }

    @Nullable
    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile, @NotNull Collection<VirtualFile> visited) {
        if (rawFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase", "getConfig"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!visited.add(rawFile.getVirtualFile())) {
            return null;
        }
        TypeScriptConfigImpl simpleConfig = TypeScriptConfigImpl.getSimpleConfigImpl(rawFile);
        if (simpleConfig == null) {
            return null;
        }
        VirtualFile parent = simpleConfig.getExtendsParent();
        if (parent == null) {
            return simpleConfig;
        }
        PsiManager manager = rawFile.getManager();
        PsiFile parentFile = manager.findFile(parent);
        if (parentFile == null) {
            return simpleConfig;
        }
        TypeScriptConfig parentConfig = TypeScriptConfigBase.getConfig(parentFile, visited);
        if (parentConfig == null) {
            return simpleConfig;
        }
        return new TypeScriptExtendedConfigImpl(simpleConfig, parentConfig);
    }

    @Override
    public final boolean isIncludeTypesFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase", "isIncludeTypesFile"));
        }
        boolean isEmptyTypes = this.getTypes().isEmpty();
        if (isEmptyTypes) {
            for (VirtualFile virtualFile : this.getTypeRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
        } else {
            for (VirtualFile typeDir : (Collection)this.myTypesDirectories.getValue()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)typeDir, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase", "accept"));
        }
        if (this.isDirectoryBased()) {
            return VfsUtilCore.isAncestor((VirtualFile)this.getConfigDirectory(), (VirtualFile)file, (boolean)true) && !this.isExcludedFile(file) || this.isIncludeTypesFile(file);
        }
        return this.isFromFileList(file) || this.isFromRootDirs(file) || this.isIncludedFile(file) || this.isIncludeTypesFile(file);
    }

    protected static boolean checkPattern(@NotNull String path, Pattern pattern) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase", "checkPattern"));
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }
}

