/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "js";

    @NotNull
    public String getId() {
        if (SUPPORT_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getId"));
        }
        return SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{JSPatterns.class};
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getPatternClasses"));
        }
        return classArray;
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        Language language = host.getLanguage();
        return language == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.generic.javascript";
    }

    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!psiElement.isValidHost()) {
            return false;
        }
        if (this.findCommentOwner(psiElement) == null) {
            return false;
        }
        psiElement.putUserData(InjectLanguageAction.FIX_KEY, host -> {
            BaseActionRunnable addCommentAction = this.getAddCommentAction((PsiLanguageInjectionHost)host, language.getID());
            if (addCommentAction == null) {
                return false;
            }
            addCommentAction.execute();
            return true;
        });
        return false;
    }

    @Nullable
    public BaseActionRunnable getAddCommentAction(final @NotNull PsiLanguageInjectionHost host, final @NotNull String languageID) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getAddCommentAction"));
        }
        if (languageID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageID", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getAddCommentAction"));
        }
        if (!host.isValidHost()) {
            return null;
        }
        final List<JSLiteralExpression> parts = JSInjectionController.getConcatenationParts(JSInjectionController.getTopElement(host));
        final LanguageInjectionSupport tempInjectionSupport = TemporaryPlacesRegistry.getInstance((Project)host.getProject()).getLanguageInjectionSupport();
        final PsiElement commentOwner = this.findCommentOwner(host);
        if (commentOwner == null) {
            return null;
        }
        return new WriteCommandAction.Simple(host.getProject(), new PsiFile[]{host.getContainingFile()}){

            protected void run() {
                boolean startsOnNewLine;
                PsiElement sibling = commentOwner.getPrevSibling();
                boolean bl = startsOnNewLine = sibling != null && sibling instanceof PsiWhiteSpace && sibling.textContains('\n');
                if (!startsOnNewLine) {
                    JSChangeUtil.addWs(commentOwner.getParent().getNode(), commentOwner.getNode(), "\n");
                }
                commentOwner.getParent().addBefore((PsiElement)JSLanguageInjectionSupport.createPsiFromText(host, "//language=" + languageID), commentOwner);
                for (JSLiteralExpression part : parts) {
                    tempInjectionSupport.removeInjection((PsiElement)part);
                }
            }
        };
    }

    public boolean useDefaultCommentInjector() {
        return false;
    }

    @Nullable
    public JSInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<PsiElement> commentRef) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "findCommentInjection"));
        }
        InjectorUtils.CommentInjectionData injectionData = InjectorUtils.findCommentInjectionData((PsiElement)host, (boolean)false, commentRef);
        if (injectionData == null) {
            return null;
        }
        JSInjection injection = new JSInjection("comment");
        injection.setPrefix(injectionData.getPrefix());
        injection.setSuffix(injectionData.getSuffix());
        injection.setInjectedLanguageId(injectionData.getInjectedLanguageId());
        injection.setDisplayName(injectionData.getDisplayName());
        injection.setCanReformat(Boolean.parseBoolean(injectionData.getValues().getOrDefault("format", "true")));
        return injection;
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Configuration configuration = Configuration.getProjectInstance((Project)psiElement.getProject());
        Ref commentRef = new Ref();
        BaseInjection injection = this.findCommentInjection((PsiElement)psiElement, commentRef);
        if (injection == null) {
            return false;
        }
        configuration.replaceInjectionsWithUndo(psiElement.getProject(), ContainerUtil.emptyList(), ContainerUtil.list((Object[])new BaseInjection[]{injection}), ContainerUtil.createMaybeSingletonList((Object)commentRef.get()));
        return true;
    }

    @Nullable
    private PsiElement findCommentOwner(@NotNull PsiLanguageInjectionHost injectionHost) {
        if (injectionHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionHost", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "findCommentOwner"));
        }
        PsiElement topElement = JSInjectionController.getTopElement(injectionHost);
        return PsiTreeUtil.getParentOfType((PsiElement)topElement, (Class[])new Class[]{JSSourceElement.class, JSProperty.class});
    }

    @NotNull
    private static PsiComment createPsiFromText(@NotNull PsiLanguageInjectionHost context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "createPsiFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "createPsiFromText"));
        }
        PsiComment psiComment = (PsiComment)((ASTNode)ObjectUtils.assertNotNull((Object)JSChangeUtil.createJSTreeFromText(context.getProject(), text, DialectDetector.languageDialectOfElement((PsiElement)context)))).getPsi(PsiComment.class);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "createPsiFromText"));
        }
        return psiComment;
    }

    @NotNull
    public static JSLanguageInjectionSupport getInstance() {
        JSLanguageInjectionSupport jSLanguageInjectionSupport = (JSLanguageInjectionSupport)((Object)ObjectUtils.assertNotNull((Object)InjectorUtils.findInjectionSupport((String)SUPPORT_ID)));
        if (jSLanguageInjectionSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getInstance"));
        }
        return jSLanguageInjectionSupport;
    }
}

