/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class AssignmentToForLoopParameterJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("assignment.to.for.loop.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("assignment.to.for.loop.parameter.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection$Visitor", "visitJSAssignmentExpression"));
            }
            super.visitJSAssignmentExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            this.checkForForLoopParam(lhs);
            this.checkForForeachLoopParam(lhs);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection$Visitor", "visitJSPrefixExpression"));
            }
            super.visitJSPrefixExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            JSExpression operand = expression.getExpression();
            if (operand == null) {
                return;
            }
            this.checkForForLoopParam(operand);
            this.checkForForeachLoopParam(operand);
        }

        public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection$Visitor", "visitJSPostfixExpression"));
            }
            super.visitJSPostfixExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            JSExpression operand = expression.getExpression();
            if (operand == null) {
                return;
            }
            this.checkForForLoopParam(operand);
            this.checkForForeachLoopParam(operand);
        }

        private void checkForForLoopParam(JSExpression expression) {
            if (!(expression instanceof JSReferenceExpression)) {
                return;
            }
            JSReferenceExpression ref = (JSReferenceExpression)expression;
            PsiElement element = ref.resolve();
            if (!(element instanceof JSVariable)) {
                return;
            }
            JSVariable variable = (JSVariable)element;
            if (!(variable.getParent() instanceof JSVarStatement)) {
                return;
            }
            JSVarStatement decl = (JSVarStatement)variable.getParent();
            if (decl == null) {
                return;
            }
            if (!(decl.getParent() instanceof JSForStatement)) {
                return;
            }
            JSForStatement forStatement = (JSForStatement)decl.getParent();
            assert (forStatement != null);
            if (!Visitor.isInForStatementBody(expression, forStatement)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private void checkForForeachLoopParam(JSExpression expression) {
            if (!(expression instanceof JSReferenceExpression)) {
                return;
            }
            JSReferenceExpression ref = (JSReferenceExpression)expression;
            PsiElement element = ref.resolve();
            if (!(element instanceof JSVariable)) {
                return;
            }
            JSVariable parameter = (JSVariable)element;
            PsiElement JSVarStatement2 = parameter.getParent();
            if (!(JSVarStatement2.getParent() instanceof JSForInStatement)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static boolean isInForStatementBody(JSExpression expression, JSForStatement statement) {
            JSStatement body = statement.getBody();
            return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)expression, (boolean)true);
        }
    }
}

