/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ExpressionUtil;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;
    static final Set<IElementType> bitwiseTokens = new HashSet<IElementType>(6);

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BITWISE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String replacementExpression = this.calculateReplacementExpression((JSExpression)args[0]);
        String string = InspectionJSBundle.message("pointless.bitwise.expression.problem.descriptor", replacementExpression);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("pointless.bitwise.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    String calculateReplacementExpression(JSExpression expression) {
        JSBinaryExpression exp = (JSBinaryExpression)expression;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        assert (rhs != null);
        if (tokenType.equals(JSTokenTypes.AND)) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType.equals(JSTokenTypes.OR)) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (tokenType.equals(JSTokenTypes.XOR)) {
            if (this.isAllOnes(lhs)) {
                return '~' + rhs.getText();
            }
            if (this.isAllOnes(rhs)) {
                return '~' + lhs.getText();
            }
            if (this.isZero(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType.equals(JSTokenTypes.LTLT) || tokenType.equals(JSTokenTypes.GTGT) || tokenType.equals(JSTokenTypes.GTGTGT)) {
            return lhs.getText();
        }
        return "";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(JSExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof JSLiteralExpression)) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression(expression);
        return value instanceof Integer && (Integer)value == 0;
    }

    private boolean isAllOnes(JSExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof JSLiteralExpression)) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression(expression);
        return value != null && value instanceof Integer && (Integer)value == -1;
    }

    static {
        bitwiseTokens.add(JSTokenTypes.AND);
        bitwiseTokens.add(JSTokenTypes.OR);
        bitwiseTokens.add(JSTokenTypes.XOR);
        bitwiseTokens.add(JSTokenTypes.LTLT);
        bitwiseTokens.add(JSTokenTypes.GTGT);
        bitwiseTokens.add(JSTokenTypes.GTGTGT);
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection$PointlessBitwiseVisitor", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            boolean isPointless = JSTokenTypes.AND.equals(sign) ? this.andExpressionIsPointless(lhs, rhs) : (JSTokenTypes.OR.equals(sign) ? this.orExpressionIsPointless(lhs, rhs) : (JSTokenTypes.XOR.equals(sign) ? this.xorExpressionIsPointless(lhs, rhs) : (JSTokenTypes.LTLT.equals(sign) || JSTokenTypes.GTGT.equals(sign) || JSTokenTypes.GTGTGT.equals(sign) ? this.shiftExpressionIsPointless(rhs) : false)));
            if (isPointless) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private boolean andExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean orExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean xorExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean shiftExpressionIsPointless(JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(rhs);
        }
    }

    private class PointlessBitwiseFix
    extends InspectionJSFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection$PointlessBitwiseFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSExpression expression = (JSExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionJSInspection.this.calculateReplacementExpression(expression);
            PointlessBitwiseFix.replaceExpression(expression, newExpression);
        }
    }
}

