/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallThroughInSwitchStatementJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("fall.through.in.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/FallThroughInSwitchStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/FallThroughInSwitchStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("fall.through.in.switch.statement.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*-?thro?u");

        private Visitor() {
        }

        public void visitJSSwitchStatement(JSSwitchStatement jsSwitchStatement) {
            JSCaseClause[] caseClauses = jsSwitchStatement.getCaseClauses();
            for (int i = 1; i < caseClauses.length; ++i) {
                JSStatement lastStatementOfClause;
                JSCaseClause previousClause;
                JSStatement[] statements;
                JSCaseClause clause = caseClauses[i];
                if (Visitor.isCommented(clause) || (statements = (previousClause = caseClauses[i - 1]).getStatements()).length == 0 || JSInheritedLanguagesHelper.isCaseStatementInterrupted(lastStatementOfClause = statements[statements.length - 1]) || !ControlFlowUtils.statementMayCompleteNormally(lastStatementOfClause)) continue;
                this.registerError(clause.getFirstChild());
            }
        }

        private static boolean isCommented(JSCaseClause caseClause) {
            PsiElement element = PsiTreeUtil.skipSiblingsBackward((PsiElement)caseClause, (Class[])new Class[]{PsiWhiteSpace.class});
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }
    }
}

