/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementWithNoDefaultBranchJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("switch.statement.with.no.default.branch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/SwitchStatementWithNoDefaultBranchJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/SwitchStatementWithNoDefaultBranchJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("switch.statement.with.no.default.branch.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSSwitchStatement(JSSwitchStatement jsSwitchStatement) {
            super.visitJSSwitchStatement(jsSwitchStatement);
            if (Visitor.hasDefaultBranch(jsSwitchStatement)) {
                return;
            }
            this.registerStatementError((JSStatement)jsSwitchStatement, new Object[0]);
        }

        private static boolean hasDefaultBranch(JSSwitchStatement jsSwitchStatement) {
            JSCaseClause[] caseClauses;
            for (JSCaseClause clause : caseClauses = jsSwitchStatement.getCaseClauses()) {
                if (!clause.isDefault()) continue;
                return true;
            }
            return false;
        }
    }
}

