/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TrivialIfJSInspection
extends JavaScriptInspection {
    private final TrivialIfFix fix = new TrivialIfFix();

    @NotNull
    public String getID() {
        if ("RedundantIfStatementJS" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialIfJSInspection", "getID"));
        }
        return "RedundantIfStatementJS";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("redundant.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialIfJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialIfJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("trivial.if.error.string", new Object[0]);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    public static boolean isSimplifiableImplicitReturn(JSIfStatement ifStatement) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(JSIfStatement ifStatement) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableReturn(JSIfStatement ifStatement) {
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        JSStatement elseBranch = ifStatement.getElse();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturnNegated(JSIfStatement ifStatement) {
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        JSStatement elseBranch = ifStatement.getElse();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableAssignment(JSIfStatement ifStatement) {
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        JSStatement elseBranch = ifStatement.getElse();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableAssignmentNegated(JSIfStatement ifStatement) {
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        JSStatement elseBranch = ifStatement.getElse();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(JSIfStatement ifStatement) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(JSIfStatement ifStatement) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (JSTokenTypes.EQ.equals(operator)) {
            return "=";
        }
        if (JSTokenTypes.NE.equals(operator)) {
            return "!=";
        }
        if (JSTokenTypes.LE.equals(operator)) {
            return "<=";
        }
        if (JSTokenTypes.GE.equals(operator)) {
            return ">=";
        }
        if (JSTokenTypes.LT.equals(operator)) {
            return "<=";
        }
        if (JSTokenTypes.GT.equals(operator)) {
            return ">=";
        }
        if (JSTokenTypes.EQEQ.equals(operator)) {
            return "==";
        }
        if (JSTokenTypes.EQEQEQ.equals(operator)) {
            return "===";
        }
        if (JSTokenTypes.NEQEQ.equals(operator)) {
            return "!==";
        }
        if (JSTokenTypes.PLUSEQ.equals(operator)) {
            return "+=";
        }
        if (JSTokenTypes.MINUSEQ.equals(operator)) {
            return "-=";
        }
        if (JSTokenTypes.MULTEQ.equals(operator)) {
            return "*=";
        }
        if (JSTokenTypes.DIVEQ.equals(operator)) {
            return "/=";
        }
        if (JSTokenTypes.PERCEQ.equals(operator)) {
            return "%=";
        }
        if (JSTokenTypes.XOREQ.equals(operator)) {
            return "^=";
        }
        if (JSTokenTypes.ANDEQ.equals(operator)) {
            return "&=";
        }
        if (JSTokenTypes.OREQ.equals(operator)) {
            return "|=";
        }
        if (JSTokenTypes.LTLT.equals(operator)) {
            return "<<";
        }
        if (JSTokenTypes.LTLTEQ.equals(operator)) {
            return "<<=";
        }
        if (JSTokenTypes.GTGT.equals(operator)) {
            return ">>";
        }
        if (JSTokenTypes.GTGTEQ.equals(operator)) {
            return ">>=";
        }
        if (JSTokenTypes.GTGTGT.equals(operator)) {
            return ">>>";
        }
        if (JSTokenTypes.GTGTGTEQ.equals(operator)) {
            return ">>>=";
        }
        return "unknown";
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitJSIfStatement(@NotNull JSIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/sixrr/inspectjs/control/TrivialIfJSInspection$TrivialIfVisitor", "visitJSIfStatement"));
            }
            super.visitJSIfStatement(ifStatement);
            JSExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableAssignment(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableReturn(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitReturn(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableAssignmentNegated(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableReturnNegated(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitAssignment(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitAssignmentNegated(ifStatement)) {
                this.registerStatementError((JSStatement)ifStatement, new Object[0]);
            }
        }
    }

    private static class TrivialIfFix
    extends InspectionJSFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialIfJSInspection$TrivialIfFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            JSIfStatement statement = (JSIfStatement)ifKeywordElement.getParent();
            if (TrivialIfJSInspection.isSimplifiableAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableAssignment(statement);
            } else if (TrivialIfJSInspection.isSimplifiableReturn(statement)) {
                TrivialIfFix.repaceSimplifiableReturn(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitReturn(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturn(statement);
            } else if (TrivialIfJSInspection.isSimplifiableAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableReturnNegated(statement)) {
                TrivialIfFix.repaceSimplifiableReturnNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturnNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignment(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignmentNegated(statement);
            }
        }

        private static void replaceSimplifiableImplicitReturn(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            String newStatement = "return " + ConditionalUtils.castToBoolean(condition) + ';';
            TrivialIfFix.replaceStatement((JSStatement)statement, newStatement);
            assert (nextStatement != null);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void repaceSimplifiableReturn(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            String newStatement = "return " + ConditionalUtils.castToBoolean(condition) + ';';
            TrivialIfFix.replaceStatement((JSStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignment(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            String rhsText = ConditionalUtils.castToBoolean(condition);
            JSStatement thenBranch = statement.getThen();
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
            IElementType operator = assignmentExpression.getOperationSign();
            String operatorText = TrivialIfJSInspection.getTextForOperator(operator);
            JSExpression lhs = assignmentExpression.getLOperand();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((JSStatement)statement, lhsText + operatorText + rhsText + ';');
        }

        private static void replaceSimplifiableImplicitAssignment(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (prevStatement == null) {
                return;
            }
            JSExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            JSStatement thenBranch = statement.getThen();
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
            IElementType operator = assignmentExpression.getOperationSign();
            String operatorText = TrivialIfJSInspection.getTextForOperator(operator);
            JSExpression lhs = assignmentExpression.getLOperand();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((JSStatement)statement, lhsText + operatorText + conditionText + ';');
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitAssignmentNegated(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            JSExpression condition = statement.getCondition();
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            JSStatement thenBranch = statement.getThen();
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
            IElementType operator = assignmentExpression.getOperationSign();
            String operatorText = TrivialIfJSInspection.getTextForOperator(operator);
            JSExpression lhs = assignmentExpression.getLOperand();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((JSStatement)statement, lhsText + operatorText + conditionText + ';');
            assert (prevStatement != null);
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitReturnNegated(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (nextStatement == null) {
                return;
            }
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((JSStatement)statement, newStatement);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void repaceSimplifiableReturnNegated(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((JSStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignmentNegated(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            JSStatement thenBranch = statement.getThen();
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
            IElementType operator = assignmentExpression.getOperationSign();
            String operatorText = TrivialIfJSInspection.getTextForOperator(operator);
            JSExpression lhs = assignmentExpression.getLOperand();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((JSStatement)statement, lhsText + operatorText + conditionText + ';');
        }
    }
}

