/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ExceptionCaughtLocallyJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("exception.used.for.local.control.flow.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ERRORHANDLING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("exception.caught.locally.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean isCaughtLocally(@NotNull JSThrowStatement throwStatement) {
        if (throwStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwStatement", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection", "isCaughtLocally"));
        }
        JSThrowStatement currentElement = throwStatement;
        JSSourceElement element;
        while (!((element = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, (Class[])new Class[]{JSTryStatement.class, JSFunction.class})) instanceof JSFunction)) {
            JSStatement tryBlock;
            JSTryStatement tryStatement = (JSTryStatement)element;
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getCatchBlock() != null && (tryBlock = tryStatement.getStatement()) != null && PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSThrowStatement(@NotNull JSThrowStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection$Visitor", "visitJSThrowStatement"));
            }
            super.visitJSThrowStatement(statement);
            if (!ExceptionCaughtLocallyJSInspection.isCaughtLocally(statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }
    }
}

