/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThisExpressionReferencesGlobalObjectJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("this.expression.which.references.the.global.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/ThisExpressionReferencesGlobalObjectJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/ThisExpressionReferencesGlobalObjectJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("this.expression.references.global.object.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSThisExpression(JSThisExpression jsThisExpression) {
            super.visitJSThisExpression(jsThisExpression);
            JSObjectLiteralExpression containingObject = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)jsThisExpression, JSObjectLiteralExpression.class);
            if (containingObject != null) {
                return;
            }
            PsiElement parentScope = PsiTreeUtil.getParentOfType((PsiElement)jsThisExpression, (Class[])new Class[]{JSFunction.class, JSClass.class});
            if (parentScope != null) {
                return;
            }
            XmlAttributeValue containingAttribute = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)jsThisExpression, XmlAttributeValue.class);
            if (containingAttribute != null) {
                return;
            }
            PsiFile containingFile = jsThisExpression.getContainingFile();
            if (containingFile instanceof JSExpressionCodeFragment || InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile) instanceof XmlAttributeValue) {
                return;
            }
            if (containingFile instanceof JSFile && ((JSFile)containingFile).isCommonJSModule()) {
                return;
            }
            this.registerError((PsiElement)jsThisExpression);
        }
    }
}

