/*
 * Decompiled with CFR 0.152.
 */
package jsonSchemas;

public class StylelintSchemaGenerator {
    private static final String input = "<li><a href=\"color-hex-case/\"><code>color-hex-case</code></a>: Specify lowercase or uppercase for hex colors.</li>\n<li><a href=\"color-hex-length/\"><code>color-hex-length</code></a>: Specify short or long notation for hex colors.</li>\n<li><a href=\"color-named/\"><code>color-named</code></a>: Require (where possible) or disallow named colors.</li>\n<li><a href=\"color-no-hex/\"><code>color-no-hex</code></a>: Disallow hex colors.</li>\n<li><a href=\"color-no-invalid-hex/\"><code>color-no-invalid-hex</code></a>: Disallow invalid hex colors.</li>\n</ul>\n<h3 id=\"font-family\"><a href=\"#font-family\" class=\"phenomic-HeadingAnchor\">#</a>Font family</h3>\n<ul>\n<li><a href=\"font-family-name-quotes/\"><code>font-family-name-quotes</code></a>: Specify whether or not quotation marks should be used around font family names.</li>\n</ul>\n<h3 id=\"font-weight\"><a href=\"#font-weight\" class=\"phenomic-HeadingAnchor\">#</a>Font weight</h3>\n<ul>\n<li><a href=\"font-weight-notation/\"><code>font-weight-notation</code></a>: Require numeric or named (where possible) <code>font-weight</code> values.</li>\n</ul>\n<h3 id=\"function\"><a href=\"#function\" class=\"phenomic-HeadingAnchor\">#</a>Function</h3>\n<ul>\n<li><a href=\"function-blacklist/\"><code>function-blacklist</code></a>: Specify a blacklist of disallowed functions.</li>\n<li><a href=\"function-calc-no-unspaced-operator/\"><code>function-calc-no-unspaced-operator</code></a>: Disallow an unspaced operator within <code>calc</code> functions.</li>\n<li><a href=\"function-comma-newline-after/\"><code>function-comma-newline-after</code></a>: Require a newline or disallow whitespace after the commas of functions.</li>\n<li><a href=\"function-comma-newline-before/\"><code>function-comma-newline-before</code></a>: Require a newline or disallow whitespace before the commas of functions.</li>\n<li><a href=\"function-comma-space-after/\"><code>function-comma-space-after</code></a>: Require a single space or disallow whitespace after the commas of functions.</li>\n<li><a href=\"function-comma-space-before/\"><code>function-comma-space-before</code></a>: Require a single space or disallow whitespace before the commas of functions.</li>\n<li><a href=\"function-linear-gradient-no-nonstandard-direction/\"><code>function-linear-gradient-no-nonstandard-direction</code></a>: Disallow direction values in <code>linear-gradient()</code> calls that are not valid according to the <a href=\"https://developer.mozilla.org/en-US/Web/CSS/linear-gradient#Syntax\">standard syntax</a>.</li>\n<li><a href=\"function-max-empty-lines/\"><code>function-max-empty-lines</code></a>: Limit the number of adjacent empty lines within functions.</li>\n<li><a href=\"function-name-case/\"><code>function-name-case</code></a>: Specify lowercase or uppercase for function names.</li>\n<li><a href=\"function-parentheses-newline-inside/\"><code>function-parentheses-newline-inside</code></a>: Require a newline or disallow whitespace on the inside of the parentheses of functions.</li>\n<li><a href=\"function-parentheses-space-inside/\"><code>function-parentheses-space-inside</code></a>: Require a single space or disallow whitespace on the inside of the parentheses of functions.</li>\n<li><a href=\"function-url-data-uris/\"><code>function-url-data-uris</code></a>: Require or disallow data URIs for urls.</li>\n<li><a href=\"function-url-no-scheme-relative/\"><code>function-url-no-scheme-relative</code></a>: Disallow scheme-relative urls.</li>\n<li><a href=\"function-url-quotes/\"><code>function-url-quotes</code></a>: Require or disallow quotes for urls.</li>\n<li><a href=\"function-url-scheme-whitelist/\"><code>function-url-scheme-whitelist</code></a>: Specify a whitelist of allowed url schemes.</li>\n<li><a href=\"function-whitelist/\"><code>function-whitelist</code></a>: Specify a whitelist of allowed functions.</li>\n<li><a href=\"function-whitespace-after/\"><code>function-whitespace-after</code></a>: Require or disallow whitespace after functions.</li>\n</ul>\n<h3 id=\"number\"><a href=\"#number\" class=\"phenomic-HeadingAnchor\">#</a>Number</h3>\n<ul>\n<li><a href=\"number-leading-zero/\"><code>number-leading-zero</code></a>: Require or disallow a leading zero for fractional numbers less than 1.</li>\n<li><a href=\"number-max-precision/\"><code>number-max-precision</code></a>: Limit the number of decimal places allowed in numbers.</li>\n<li><a href=\"number-no-trailing-zeros/\"><code>number-no-trailing-zeros</code></a>: Disallow trailing zeros in numbers.</li>\n</ul>\n<h3 id=\"string\"><a href=\"#string\" class=\"phenomic-HeadingAnchor\">#</a>String</h3>\n<ul>\n<li><a href=\"string-no-newline/\"><code>string-no-newline</code></a>: Disallow (unescaped) newlines in strings.</li>\n<li><a href=\"string-quotes/\"><code>string-quotes</code></a>: Specify single or double quotes around strings.</li>\n</ul>\n<h3 id=\"length\"><a href=\"#length\" class=\"phenomic-HeadingAnchor\">#</a>Length</h3>\n<ul>\n<li><a href=\"length-zero-no-unit/\"><code>length-zero-no-unit</code></a>: Disallow units for zero lengths.</li>\n</ul>\n<h3 id=\"time\"><a href=\"#time\" class=\"phenomic-HeadingAnchor\">#</a>Time</h3>\n<ul>\n<li><a href=\"time-no-imperceptible/\"><code>time-no-imperceptible</code></a>: Disallow <code>animation</code> and <code>transition</code> less than or equal to 100ms.</li>\n</ul>\n<h3 id=\"unit\"><a href=\"#unit\" class=\"phenomic-HeadingAnchor\">#</a>Unit</h3>\n<ul>\n<li><a href=\"unit-blacklist/\"><code>unit-blacklist</code></a>: Specify a blacklist of disallowed units.</li>\n<li><a href=\"unit-case/\"><code>unit-case</code></a>: Specify lowercase or uppercase for units.</li>\n<li><a href=\"unit-no-unknown/\"><code>unit-no-unknown</code></a>: Disallow unknown units.</li>\n<li><a href=\"unit-whitelist/\"><code>unit-whitelist</code></a>: Specify a whitelist of allowed units.</li>\n</ul>\n<h3 id=\"value\"><a href=\"#value\" class=\"phenomic-HeadingAnchor\">#</a>Value</h3>\n<ul>\n<li><a href=\"value-keyword-case/\"><code>value-keyword-case</code></a>: Specify lowercase or uppercase for keywords values.</li>\n<li><a href=\"value-no-vendor-prefix/\"><code>value-no-vendor-prefix</code></a>: Disallow vendor prefixes for values.</li>\n</ul>\n<h3 id=\"value-list\"><a href=\"#value-list\" class=\"phenomic-HeadingAnchor\">#</a>Value list</h3>\n<ul>\n<li><a href=\"value-list-comma-newline-after/\"><code>value-list-comma-newline-after</code></a>: Require a newline or disallow whitespace after the commas of value lists.</li>\n<li><a href=\"value-list-comma-newline-before/\"><code>value-list-comma-newline-before</code></a>: Require a newline or disallow whitespace before the commas of value lists.</li>\n<li><a href=\"value-list-comma-space-after/\"><code>value-list-comma-space-after</code></a>: Require a single space or disallow whitespace after the commas of value lists.</li>\n<li><a href=\"value-list-comma-space-before/\"><code>value-list-comma-space-before</code></a>: Require a single space or disallow whitespace before the commas of value lists.</li>\n<li><a href=\"value-list-max-empty-lines/\"><code>value-list-max-empty-lines</code></a>: Limit the number of adjacent empty lines within value lists.</li>\n</ul>\n<h3 id=\"custom-property\"><a href=\"#custom-property\" class=\"phenomic-HeadingAnchor\">#</a>Custom property</h3>\n<ul>\n<li><a href=\"custom-property-empty-line-before/\"><code>custom-property-empty-line-before</code></a>: Require or disallow an empty line before custom properties.</li>\n<li><a href=\"custom-property-no-outside-root/\"><code>custom-property-no-outside-root</code></a>: Disallow custom properties outside of <code>:root</code> rules.</li>\n<li><a href=\"custom-property-pattern/\"><code>custom-property-pattern</code></a>: Specify a pattern for custom properties.</li>\n</ul>\n<h3 id=\"shorthand-property\"><a href=\"#shorthand-property\" class=\"phenomic-HeadingAnchor\">#</a>Shorthand property</h3>\n<ul>\n<li><a href=\"shorthand-property-no-redundant-values/\"><code>shorthand-property-no-redundant-values</code></a>: Disallow redundant values in shorthand properties.</li>\n</ul>\n<h3 id=\"property\"><a href=\"#property\" class=\"phenomic-HeadingAnchor\">#</a>Property</h3>\n<ul>\n<li><a href=\"property-blacklist/\"><code>property-blacklist</code></a>: Specify a blacklist of disallowed properties.</li>\n<li><a href=\"property-case/\"><code>property-case</code></a>: Specify lowercase or uppercase for properties.</li>\n<li><a href=\"property-no-unknown/\"><code>property-no-unknown</code></a>: Disallow unknown properties.</li>\n<li><a href=\"property-no-vendor-prefix/\"><code>property-no-vendor-prefix</code></a>: Disallow vendor prefixes for properties.</li>\n<li><a href=\"property-whitelist/\"><code>property-whitelist</code></a>: Specify a whitelist of allowed properties.</li>\n</ul>\n<h3 id=\"keyframe-declaration\"><a href=\"#keyframe-declaration\" class=\"phenomic-HeadingAnchor\">#</a>Keyframe declaration</h3>\n<ul>\n<li><a href=\"keyframe-declaration-no-important/\"><code>keyframe-declaration-no-important</code></a>: Disallow <code>!important</code> within keyframe declarations.</li>\n</ul>\n<h3 id=\"declaration\"><a href=\"#declaration\" class=\"phenomic-HeadingAnchor\">#</a>Declaration</h3>\n<ul>\n<li><a href=\"declaration-bang-space-after/\"><code>declaration-bang-space-after</code></a>: Require a single space or disallow whitespace after the bang of declarations.</li>\n<li><a href=\"declaration-bang-space-before/\"><code>declaration-bang-space-before</code></a>: Require a single space or disallow whitespace before the bang of declarations.</li>\n<li><a href=\"declaration-colon-newline-after/\"><code>declaration-colon-newline-after</code></a>: Require a newline or disallow whitespace after the colon of declarations.</li>\n<li><a href=\"declaration-colon-space-after/\"><code>declaration-colon-space-after</code></a>: Require a single space or disallow whitespace after the colon of declarations.</li>\n<li><a href=\"declaration-colon-space-before/\"><code>declaration-colon-space-before</code></a>: Require a single space or disallow whitespace before the colon of declarations.</li>\n<li><a href=\"declaration-empty-line-before/\"><code>declaration-empty-line-before</code></a>: Require or disallow an empty line before declarations.</li>\n<li><a href=\"declaration-no-important/\"><code>declaration-no-important</code></a>: Disallow <code>!important</code> within declarations.</li>\n<li><a href=\"declaration-property-unit-blacklist/\"><code>declaration-property-unit-blacklist</code></a>: Specify a blacklist of disallowed property and unit pairs within declarations.</li>\n<li><a href=\"declaration-property-unit-whitelist/\"><code>declaration-property-unit-whitelist</code></a>: Specify a whitelist of allowed property and unit pairs within declarations.</li>\n<li><a href=\"declaration-property-value-blacklist/\"><code>declaration-property-value-blacklist</code></a>: Specify a blacklist of disallowed property and value pairs within declarations.</li>\n<li><a href=\"declaration-property-value-whitelist/\"><code>declaration-property-value-whitelist</code></a>: Specify a whitelist of allowed property and value pairs within declarations.</li>\n</ul>\n<h3 id=\"declaration-block\"><a href=\"#declaration-block\" class=\"phenomic-HeadingAnchor\">#</a>Declaration block</h3>\n<ul>\n<li><a href=\"declaration-block-no-duplicate-properties/\"><code>declaration-block-no-duplicate-properties</code></a>: Disallow duplicate properties within declaration blocks.</li>\n<li><a href=\"declaration-block-no-ignored-properties/\"><code>declaration-block-no-ignored-properties</code></a>: Disallow property values that are ignored due to another property value in the same rule.</li>\n<li><a href=\"declaration-block-no-redundant-longhand-properties/\"><code>declaration-block-no-redundant-longhand-properties</code></a>: Disallow longhand properties that can be combined into one shorthand property.</li>\n<li><a href=\"declaration-block-no-shorthand-property-overrides/\"><code>declaration-block-no-shorthand-property-overrides</code></a>: Disallow shorthand properties that override related longhand properties within declaration blocks.</li>\n<li><a href=\"declaration-block-properties-order/\"><code>declaration-block-properties-order</code></a>: Specify the order of properties within declaration blocks.</li>\n<li><a href=\"declaration-block-semicolon-newline-after/\"><code>declaration-block-semicolon-newline-after</code></a>: Require a newline or disallow whitespace after the semicolons of declaration blocks.</li>\n<li><a href=\"declaration-block-semicolon-newline-before/\"><code>declaration-block-semicolon-newline-before</code></a>: Require a newline or disallow whitespace before the semicolons of declaration blocks.</li>\n<li><a href=\"declaration-block-semicolon-space-after/\"><code>declaration-block-semicolon-space-after</code></a>: Require a single space or disallow whitespace after the semicolons of declaration blocks.</li>\n<li><a href=\"declaration-block-semicolon-space-before/\"><code>declaration-block-semicolon-space-before</code></a>: Require a single space or disallow whitespace before the semicolons of declaration blocks.</li>\n<li><a href=\"declaration-block-single-line-max-declarations/\"><code>declaration-block-single-line-max-declarations</code></a>: Limit the number of declaration within single line declaration blocks.</li>\n<li><a href=\"declaration-block-trailing-semicolon/\"><code>declaration-block-trailing-semicolon</code></a>: Require or disallow a trailing semicolon within declaration blocks.</li>\n</ul>\n<h3 id=\"block\"><a href=\"#block\" class=\"phenomic-HeadingAnchor\">#</a>Block</h3>\n<ul>\n<li><a href=\"block-closing-brace-empty-line-before/\"><code>block-closing-brace-empty-line-before</code></a>: Require or disallow an empty line before the closing brace of blocks.</li>\n<li><a href=\"block-closing-brace-newline-after/\"><code>block-closing-brace-newline-after</code></a>: Require a newline or disallow whitespace after the closing brace of blocks.</li>\n<li><a href=\"block-closing-brace-newline-before/\"><code>block-closing-brace-newline-before</code></a>: Require a newline or disallow whitespace before the closing brace of blocks.</li>\n<li><a href=\"block-closing-brace-space-after/\"><code>block-closing-brace-space-after</code></a>: Require a single space or disallow whitespace after the closing brace of blocks.</li>\n<li><a href=\"block-closing-brace-space-before/\"><code>block-closing-brace-space-before</code></a>: Require a single space or disallow whitespace before the closing brace of blocks.</li>\n<li><a href=\"block-no-empty/\"><code>block-no-empty</code></a>: Disallow empty blocks.</li>\n<li><a href=\"block-no-single-line/\"><code>block-no-single-line</code></a>: Disallow single-line blocks.</li>\n<li><a href=\"block-opening-brace-newline-after/\"><code>block-opening-brace-newline-after</code></a>: Require a newline after the opening brace of blocks.</li>\n<li><a href=\"block-opening-brace-newline-before/\"><code>block-opening-brace-newline-before</code></a>: Require a newline or disallow whitespace before the opening brace of blocks.</li>\n<li><a href=\"block-opening-brace-space-after/\"><code>block-opening-brace-space-after</code></a>: Require a single space or disallow whitespace after the opening brace of blocks.</li>\n<li><a href=\"block-opening-brace-space-before/\"><code>block-opening-brace-space-before</code></a>: Require a single space or disallow whitespace before the opening brace of blocks.</li>\n</ul>\n<h3 id=\"selector\"><a href=\"#selector\" class=\"phenomic-HeadingAnchor\">#</a>Selector</h3>\n<ul>\n<li><a href=\"selector-attribute-brackets-space-inside/\"><code>selector-attribute-brackets-space-inside</code></a>: Require a single space or disallow whitespace on the inside of the brackets within attribute selectors.</li>\n<li><a href=\"selector-attribute-operator-blacklist/\"><code>selector-attribute-operator-blacklist</code></a>: Specify a blacklist of disallowed attribute operators.</li>\n<li><a href=\"selector-attribute-operator-space-after/\"><code>selector-attribute-operator-space-after</code></a>: Require a single space or disallow whitespace after operators within attribute selectors.</li>\n<li><a href=\"selector-attribute-operator-space-before/\"><code>selector-attribute-operator-space-before</code></a>: Require a single space or disallow whitespace before operators within attribute selectors.</li>\n<li><a href=\"selector-attribute-operator-whitelist/\"><code>selector-attribute-operator-whitelist</code></a>: Specify a whitelist of allowed attribute operators.</li>\n<li><a href=\"selector-attribute-quotes/\"><code>selector-attribute-quotes</code></a>: Require or disallow quotes for attribute values.</li>\n<li><a href=\"selector-class-pattern/\"><code>selector-class-pattern</code></a>: Specify a pattern for class selectors.</li>\n<li><a href=\"selector-combinator-space-after/\"><code>selector-combinator-space-after</code></a>: Require a single space or disallow whitespace after the combinators of selectors.</li>\n<li><a href=\"selector-combinator-space-before/\"><code>selector-combinator-space-before</code></a>: Require a single space or disallow whitespace before the combinators of selectors.</li>\n<li><a href=\"selector-descendant-combinator-no-non-space/\"><code>selector-descendant-combinator-no-non-space</code></a>: Disallow non-space characters for descendant combinators of selectors.</li>\n<li><a href=\"selector-id-pattern/\"><code>selector-id-pattern</code></a>: Specify a pattern for id selectors.</li>\n<li><a href=\"selector-max-compound-selectors/\"><code>selector-max-compound-selectors</code></a>: Limit the number of compound selectors in a selector.</li>\n<li><a href=\"selector-max-specificity/\"><code>selector-max-specificity</code></a>: Limit the specificity of selectors.</li>\n<li><a href=\"selector-nested-pattern/\"><code>selector-nested-pattern</code></a>: Specify a pattern for the selectors of rules nested within rules.</li>\n<li><a href=\"selector-no-attribute/\"><code>selector-no-attribute</code></a>: Disallow attribute selectors.</li>\n<li><a href=\"selector-no-combinator/\"><code>selector-no-combinator</code></a>: Disallow combinators in selectors.</li>\n<li><a href=\"selector-no-id/\"><code>selector-no-id</code></a>: Disallow id selectors.</li>\n<li><a href=\"selector-no-qualifying-type/\"><code>selector-no-qualifying-type</code></a>: Disallow qualifying a selector by type.</li>\n<li><a href=\"selector-no-type/\"><code>selector-no-type</code></a>: Disallow type selectors.</li>\n<li><a href=\"selector-no-universal/\"><code>selector-no-universal</code></a>: Disallow the universal selector.</li>\n<li><a href=\"selector-no-vendor-prefix/\"><code>selector-no-vendor-prefix</code></a>: Disallow vendor prefixes for selectors.</li>\n<li><a href=\"selector-pseudo-class-blacklist/\"><code>selector-pseudo-class-blacklist</code></a>: Specify a blacklist of disallowed pseudo-class selectors.</li>\n<li><a href=\"selector-pseudo-class-case/\"><code>selector-pseudo-class-case</code></a>: Specify lowercase or uppercase for pseudo-class selectors.</li>\n<li><a href=\"selector-pseudo-class-no-unknown/\"><code>selector-pseudo-class-no-unknown</code></a>: Disallow unknown pseudo-class selectors.</li>\n<li><a href=\"selector-pseudo-class-parentheses-space-inside/\"><code>selector-pseudo-class-parentheses-space-inside</code></a>: Require a single space or disallow whitespace on the inside of the parentheses within pseudo-class selectors.</li>\n<li><a href=\"selector-pseudo-class-whitelist/\"><code>selector-pseudo-class-whitelist</code></a>: Specify a whitelist of allowed pseudo-class selectors.</li>\n<li><a href=\"selector-pseudo-element-case/\"><code>selector-pseudo-element-case</code></a>: Specify lowercase or uppercase for pseudo-element selectors.</li>\n<li><a href=\"selector-pseudo-element-colon-notation/\"><code>selector-pseudo-element-colon-notation</code></a>: Specify single or double colon notation for applicable pseudo-elements.</li>\n<li><a href=\"selector-pseudo-element-no-unknown/\"><code>selector-pseudo-element-no-unknown</code></a>: Disallow unknown pseudo-element selectors.</li>\n<li><a href=\"selector-root-no-composition/\"><code>selector-root-no-composition</code></a>: Disallow the composition of <code>:root</code> in selectors.</li>\n<li><a href=\"selector-type-case/\"><code>selector-type-case</code></a>: Specify lowercase or uppercase for type selector.</li>\n<li><a href=\"selector-type-no-unknown/\"><code>selector-type-no-unknown</code></a>: Disallow unknown type selectors.</li>\n<li><a href=\"selector-max-empty-lines/\"><code>selector-max-empty-lines</code></a>: Limit the number of adjacent empty lines within selectors.</li>\n</ul>\n<h3 id=\"selector-list\"><a href=\"#selector-list\" class=\"phenomic-HeadingAnchor\">#</a>Selector list</h3>\n<ul>\n<li><a href=\"selector-list-comma-newline-after/\"><code>selector-list-comma-newline-after</code></a>: Require a newline or disallow whitespace after the commas of selector lists.</li>\n<li><a href=\"selector-list-comma-newline-before/\"><code>selector-list-comma-newline-before</code></a>: Require a newline or disallow whitespace before the commas of selector lists.</li>\n<li><a href=\"selector-list-comma-space-after/\"><code>selector-list-comma-space-after</code></a>: Require a single space or disallow whitespace after the commas of selector lists.</li>\n<li><a href=\"selector-list-comma-space-before/\"><code>selector-list-comma-space-before</code></a>: Require a single space or disallow whitespace before the commas of selector lists.</li>\n</ul>\n<h3 id=\"root-rule\"><a href=\"#root-rule\" class=\"phenomic-HeadingAnchor\">#</a>Root rule</h3>\n<ul>\n<li><a href=\"root-no-standard-properties/\"><code>root-no-standard-properties</code></a>: Disallow standard properties inside <code>:root</code> rules.</li>\n</ul>\n<h3 id=\"rule\"><a href=\"#rule\" class=\"phenomic-HeadingAnchor\">#</a>Rule</h3>\n<ul>\n<li><a href=\"rule-nested-empty-line-before/\"><code>rule-nested-empty-line-before</code></a>: Require or disallow an empty line before nested rules.</li>\n<li><a href=\"rule-non-nested-empty-line-before/\"><code>rule-non-nested-empty-line-before</code></a>: Require or disallow an empty line before non-nested rules.</li>\n</ul>\n<h3 id=\"media-feature\"><a href=\"#media-feature\" class=\"phenomic-HeadingAnchor\">#</a>Media feature</h3>\n<ul>\n<li><a href=\"media-feature-colon-space-after/\"><code>media-feature-colon-space-after</code></a>: Require a single space or disallow whitespace after the colon in media features.</li>\n<li><a href=\"media-feature-colon-space-before/\"><code>media-feature-colon-space-before</code></a>: Require a single space or disallow whitespace before the colon in media features.</li>\n<li><a href=\"media-feature-name-case/\"><code>media-feature-name-case</code></a>: Specify lowercase or uppercase for media feature names.</li>\n<li><a href=\"media-feature-name-no-unknown/\"><code>media-feature-name-no-unknown</code></a>: Disallow unknown media feature names.</li>\n<li><a href=\"media-feature-name-no-vendor-prefix/\"><code>media-feature-name-no-vendor-prefix</code></a>: Disallow vendor prefixes for media feature names.</li>\n<li><a href=\"media-feature-no-missing-punctuation/\"><code>media-feature-no-missing-punctuation</code></a>: Disallow missing punctuation for non-boolean media features.</li>\n<li><a href=\"media-feature-parentheses-space-inside/\"><code>media-feature-parentheses-space-inside</code></a>: Require a single space or disallow whitespace on the inside of the parentheses within media features.</li>\n<li><a href=\"media-feature-range-operator-space-after/\"><code>media-feature-range-operator-space-after</code></a>: Require a single space or disallow whitespace after the range operator in media features.</li>\n<li><a href=\"media-feature-range-operator-space-before/\"><code>media-feature-range-operator-space-before</code></a>: Require a single space or disallow whitespace before the range operator in media features.</li>\n</ul>\n<h3 id=\"custom-media\"><a href=\"#custom-media\" class=\"phenomic-HeadingAnchor\">#</a>Custom media</h3>\n<ul>\n<li><a href=\"custom-media-pattern/\"><code>custom-media-pattern</code></a>: Specify a pattern for custom media query names.</li>\n</ul>\n<h3 id=\"media-query-list\"><a href=\"#media-query-list\" class=\"phenomic-HeadingAnchor\">#</a>Media query list</h3>\n<ul>\n<li><a href=\"media-query-list-comma-newline-after/\"><code>media-query-list-comma-newline-after</code></a>: Require a newline or disallow whitespace after the commas of media query lists.</li>\n<li><a href=\"media-query-list-comma-newline-before/\"><code>media-query-list-comma-newline-before</code></a>: Require a newline or disallow whitespace before the commas of media query lists.</li>\n<li><a href=\"media-query-list-comma-space-after/\"><code>media-query-list-comma-space-after</code></a>: Require a single space or disallow whitespace after the commas of media query lists.</li>\n<li><a href=\"media-query-list-comma-space-before/\"><code>media-query-list-comma-space-before</code></a>: Require a single space or disallow whitespace before the commas of media query lists.</li>\n</ul>\n<h3 id=\"at-rule\"><a href=\"#at-rule\" class=\"phenomic-HeadingAnchor\">#</a>At-rule</h3>\n<ul>\n<li><a href=\"at-rule-blacklist/\"><code>at-rule-blacklist</code></a>: Specify a blacklist of disallowed at-rules.</li>\n<li><a href=\"at-rule-empty-line-before/\"><code>at-rule-empty-line-before</code></a>: Require or disallow an empty line before at-rules.</li>\n<li><a href=\"at-rule-name-case/\"><code>at-rule-name-case</code></a>: Specify lowercase or uppercase for at-rules names.</li>\n<li><a href=\"at-rule-name-newline-after/\"><code>at-rule-name-newline-after</code></a>: Require a newline after at-rule names.</li>\n<li><a href=\"at-rule-name-space-after/\"><code>at-rule-name-space-after</code></a>: Require a single space after at-rule names.</li>\n<li><a href=\"at-rule-no-unknown/\"><code>at-rule-no-unknown</code></a>: Disallow unknown at-rules.</li>\n<li><a href=\"at-rule-no-vendor-prefix/\"><code>at-rule-no-vendor-prefix</code></a>: Disallow vendor prefixes for at-rules.</li>\n<li><a href=\"at-rule-semicolon-newline-after/\"><code>at-rule-semicolon-newline-after</code></a>: Require a newline after the semicolon of at-rules.</li>\n<li><a href=\"at-rule-whitelist/\"><code>at-rule-whitelist</code></a>: Specify a whitelist of allowed at-rules.</li>\n</ul>\n<ul>\n<li><a href=\"stylelint-disable-reason/\"><code>stylelint-disable-reason</code></a>: Require a reason comment before or after <code>stylelint-disable</code> comments.</li>\n</ul>\n<h3 id=\"comment\"><a href=\"#comment\" class=\"phenomic-HeadingAnchor\">#</a>Comment</h3>\n<ul>\n<li><a href=\"comment-empty-line-before/\"><code>comment-empty-line-before</code></a>: Require or disallow an empty line before comments.</li>\n<li><a href=\"comment-no-empty/\"><code>comment-no-empty</code></a>:  Disallow empty comments.</li>\n<li><a href=\"comment-whitespace-inside/\"><code>comment-whitespace-inside</code></a>: Require or disallow whitespace on the inside of comment markers.</li>\n<li><a href=\"comment-word-blacklist/\"><code>comment-word-blacklist</code></a>: Specify a blacklist of disallowed words within comments.</li>\n</ul>\n<h3 id=\"general--sheet\"><a href=\"#general--sheet\" class=\"phenomic-HeadingAnchor\">#</a>General / Sheet</h3>\n<ul>\n<li><a href=\"indentation/\"><code>indentation</code></a>: Specify indentation.</li>\n<li><a href=\"max-empty-lines/\"><code>max-empty-lines</code></a>: Limit the number of adjacent empty lines.</li>\n<li><a href=\"max-line-length/\"><code>max-line-length</code></a>: Limit the length of a line.</li>\n<li><a href=\"max-nesting-depth/\"><code>max-nesting-depth</code></a>: Limit the depth of nesting.</li>\n<li><a href=\"no-browser-hacks/\"><code>no-browser-hacks</code></a>: Disallow browser hacks that are irrelevant to the browsers you are targeting.</li>\n<li><a href=\"no-descending-specificity/\"><code>no-descending-specificity</code></a>: Disallow selectors of lower specificity from coming after overriding selectors of higher specificity.</li>\n<li><a href=\"no-duplicate-selectors/\"><code>no-duplicate-selectors</code></a>: Disallow duplicate selectors.</li>\n<li><a href=\"no-empty-source/\"><code>no-empty-source</code></a>: Disallow empty sources.</li>\n<li><a href=\"no-eol-whitespace/\"><code>no-eol-whitespace</code></a>: Disallow end-of-line whitespace.</li>\n<li><a href=\"no-extra-semicolons/\"><code>no-extra-semicolons</code></a>: Disallow extra semicolons.</li>\n<li><a href=\"no-indistinguishable-colors/\"><code>no-indistinguishable-colors</code></a>: Disallow colors that are suspiciously close to being identical.</li>\n<li><a href=\"no-invalid-double-slash-comments/\"><code>no-invalid-double-slash-comments</code></a>: Disallow double-slash comments (<code>//...</code>) which are not supported by CSS.</li>\n<li><a href=\"no-missing-end-of-source-newline/\"><code>no-missing-end-of-source-newline</code></a>: Disallow missing end-of-source newlines.</li>\n<li><a href=\"no-unknown-animations/\"><code>no-unknown-animations</code></a>: Disallow animation names that do not correspond to a <code>@keyframes</code> declaration.</li>\n<li><a href=\"no-unsupported-browser-features/\"><code>no-unsupported-browser-features</code></a>: Disallow features that are unsupported by the browsers that you are targeting.</li>";
    public static final String END = "</code></a>:";

    public static void main(String[] args) {
        System.out.println("{\n  \"$schema\": \"http://json-schema.org/draft-04/schema#\",\n  \"type\": \"object\",\n  \"id\": \"https://jetbrains.com/stylelintrc.json\",\n  \"title\": \"JSON schema for Stylint (CSS linter) configuration files\",\n  \"description\": \"Stylelint, CSS linter\",\n  \"properties\": {");
        int cnt = 0;
        try {
            int idx = 0;
            while (true) {
                int nextCode;
                if ((nextCode = input.indexOf("<code>", idx)) == -1) {
                    return;
                }
                int finish = input.indexOf(END, nextCode + 6);
                if (finish == -1) {
                    return;
                }
                String name = input.substring(nextCode + 6, finish).trim();
                for (int i = 0; i < name.length(); ++i) {
                    if (Character.isLetter(name.charAt(i)) || name.charAt(i) == '-') continue;
                    return;
                }
                int descrEnd = input.indexOf("</li>", finish + END.length());
                if (descrEnd == -1) {
                    return;
                }
                if (cnt > 0) {
                    System.out.print(",");
                }
                System.out.println("\n\"" + name + "\": {\n\"description\": \"" + input.substring(finish + END.length(), descrEnd).trim() + "\"\n}");
                ++cnt;
                idx = descrEnd;
            }
        }
        finally {
            System.out.println("}\n}");
        }
    }
}

