/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramDataModelWrapper
extends GraphDataModel<DiagramNode, DiagramEdge> {
    private final DiagramDataModel<?> myModel;
    private static final Key<Boolean> NOTE_MARKER = Key.create((String)"UML_NOTE_MARKER");

    public DiagramDataModelWrapper(DiagramDataModel model) {
        this.myModel = model;
        Disposer.register((Disposable)this, (Disposable)model);
    }

    public DiagramDataModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Collection<DiagramNode> getNodes() {
        DiagramBuilder builder = this.myModel.getBuilder();
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>(this.myModel.getNodes());
        Map<DiagramNode, DiagramNoteNode> notes = this.myModel.getNotes();
        for (DiagramNode diagramNode : notes.keySet()) {
            DiagramNoteNode note = notes.get(diagramNode);
            if (nodes.contains(diagramNode)) {
                nodes.add(note);
                note.putUserData(NOTE_MARKER, true);
                continue;
            }
            note.putUserData(NOTE_MARKER, false);
        }
        for (DiagramNode<Object> diagramNode : nodes) {
            diagramNode.putUserData(Utils.GRAPH_BUILDER, builder);
        }
        ArrayList<DiagramNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getNodes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge> getEdges() {
        ArrayList<DiagramEdge> edges = new ArrayList<DiagramEdge>();
        edges.addAll(this.myModel.getEdges());
        for (DiagramNoteEdge edge : this.myModel.getNoteEdges()) {
            DiagramNode target = edge.getTarget();
            Boolean enable = (Boolean)target.getUserData(NOTE_MARKER);
            if (enable == null || !enable.booleanValue()) continue;
            edges.add(edge);
        }
        ArrayList<DiagramEdge> arrayList = edges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getEdges"));
        }
        return arrayList;
    }

    @NotNull
    public DiagramNode getSourceNode(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            DiagramNode diagramNode = umlEdge.getSource();
            if (diagramNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getSourceNode"));
            }
            return diagramNode;
        }
        DiagramNode<?> diagramNode = this.myModel.getSourceNode(umlEdge);
        if (diagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getSourceNode"));
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode getTargetNode(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            DiagramNode diagramNode = umlEdge.getTarget();
            if (diagramNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getTargetNode"));
            }
            return diagramNode;
        }
        DiagramNode<?> diagramNode = this.myModel.getTargetNode(umlEdge);
        if (diagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getTargetNode"));
        }
        return diagramNode;
    }

    @NotNull
    public String getNodeName(DiagramNode umlNode) {
        if (umlNode instanceof DiagramNoteNode) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getNodeName"));
            }
            return "";
        }
        String string = this.myModel.getNodeName(umlNode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getEdgeName"));
            }
            return "";
        }
        String string = this.myModel.getEdgeName(umlEdge);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModelWrapper", "getEdgeName"));
        }
        return string;
    }

    public DiagramEdge createEdge(@NotNull DiagramNode from, @NotNull DiagramNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/diagram/DiagramDataModelWrapper", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/diagram/DiagramDataModelWrapper", "createEdge"));
        }
        return this.myModel.createEdge(from, to);
    }

    public void dispose() {
    }

    @Nullable
    public NodesGroup getGroup(DiagramNode node) {
        return this.myModel.getGroup(node);
    }
}

