/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import gnu.trove.THashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramNodeBase<T>
implements DiagramNode<T>,
Navigatable {
    private String qualifiedName;
    private int hashCode;
    private final DiagramProvider<T> myProvider;
    private final THashMap myUserData;

    public DiagramNodeBase(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diagram/DiagramNodeBase", "<init>"));
        }
        this.qualifiedName = null;
        this.hashCode = 0;
        this.myUserData = new THashMap();
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public final DiagramProvider<T> getProvider() {
        DiagramProvider<T> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramNodeBase", "getProvider"));
        }
        return diagramProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramNodeBase that = (DiagramNodeBase)o;
        String thatFQN = that.getFQN();
        String fqn = this.getFQN();
        return fqn != null && fqn.length() > 0 && fqn.equals(thatFQN);
    }

    public int hashCode() {
        String fqn = this.getFQN();
        if (fqn == null) {
            return 0;
        }
        if (this.hashCode == 0) {
            this.hashCode = fqn.hashCode();
        }
        return this.hashCode;
    }

    protected String getFQN() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.getProvider().getVfsResolver().getQualifiedName(this.getIdentifyingElement());
        }
        return this.qualifiedName;
    }

    public void navigate(boolean requestFocus) {
        DiagramUtils.navigateTo(this);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramNodeBase", "getUserData"));
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramNodeBase", "putUserData"));
        }
        this.myUserData.put(key, value);
    }

    public String toString() {
        return this.getTooltip();
    }
}

